% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsCurve.R
\name{kontextCurve}
\alias{kontextCurve}
\title{Evaluation of Kontextual over a range of radii.}
\usage{
kontextCurve(
  cells,
  from,
  to,
  parent,
  image = NULL,
  rs = seq(10, 100, 10),
  inhom = FALSE,
  edge = TRUE,
  se = FALSE,
  nSim = 20,
  cores = 1,
  imageID = "imageID",
  cellType = "cellType",
  ...
)
}
\arguments{
\item{cells}{A single image from a SingleCellExperiment object}

\item{from}{The first cell type to be evaluated in the pairwise relationship.}

\item{to}{The second cell type to be evaluated in the pairwise relationship.}

\item{parent}{The parent population of the from cell type (must include from cell type).}

\item{image}{A vector of images to subset the results to. If NULL we default to all images.}

\item{rs}{A vector of radii to evaluate kontextual over.}

\item{inhom}{A logical value indicating whether to perform an inhomogeneous L function.}

\item{edge}{A logical value indicating whether to perform edge correction.}

\item{se}{A logical value to indicate if the standard deviation of
kontextual should be calculated to construct error bars.}

\item{nSim}{Number of randomisations to perform using \code{\link[Statial]{relabelKontextual}},
which will be used to calculated the SE.}

\item{cores}{Number of cores for parallel processing.}

\item{imageID}{The column in colData that stores the image ids.}

\item{cellType}{The column in colData that stores the cell types.}

\item{...}{Any arguments passed into \code{\link[Statial]{Kontextual}}.}
}
\value{
A data frame of original L values and Kontextual values evaluated
over a range of radii.
}
\description{
This function obtains `Kontextual` values over a range of radii, standard
deviations for each value can be obtained using permutation for significance
testing. To obtain estimates for standard deviations specify `se = TRUE`.
}
\examples{

data("kerenSCE")

kerenImage6 <- kerenSCE[, kerenSCE$imageID == "6"]

rsDf <- kontextCurve(
  cells = kerenSCE,
  from = "CD4_Cell",
  to = "Keratin_Tumour",
  parent = c("CD4_Cell", "Macrophages"),
  rs = seq(10, 510, 100),
  cores = 2
)

}
