% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{matrixDB_to_listDB}
\alias{matrixDB_to_listDB}
\title{Re-formatting ChIP-Gene database}
\usage{
matrixDB_to_listDB(Mat01)
}
\arguments{
\item{Mat01}{Matrix[n,m] which rows correspond to all the human
genes that have been assigned an Entrez ID, and its columns, to every
ChIP-Seq experiment in the database. The values are 1 – if the ChIP-Seq
has a peak assigned to that gene – or 0 – if it hasn’t –.}
}
\value{
List containing two elements:
   - Gene Keys: vector of gene IDs
   - ChIP Targets: list of vectors, one per ChIP-seq experiment in the,
     database, containing the putative targets assigned. Each target is
     coded as its position in the vector 'Gene Keys'.
}
\description{
Function to transform a ChIP-gene data base from the former
binary matrix to the current list-based format.
}
\examples{
Mat01 <- matrix( 
    round( runif(9) ), nrow = 3,
    dimnames= list( paste0("Gene ", 1:3), paste0("ChIPseq ", 1:3))  )
matrixDB_to_listDB( Mat01 )
}
