% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tronco.R
\name{tronco.caprese}
\alias{tronco.caprese}
\title{tronco caprese}
\usage{
tronco.caprese(data, lambda = 0.5, silent = FALSE, epos = 0, eneg = 0)
}
\arguments{
\item{data}{A TRONCO compliant dataset.}

\item{lambda}{Coefficient to combine the raw estimate with a correction factor into a shrinkage estimator.}

\item{silent}{A parameter to disable/enable verbose messages.}

\item{epos}{Error rate of false positive errors.}

\item{eneg}{Error rate of false negative errors.}
}
\value{
A TRONCO compliant object with reconstructed model
}
\description{
Reconstruct a progression model using CAPRESE algorithm. For details and examples
regarding the inference process and on the algorithm implemented in the package,
we refer to the Vignette Section 6.
}
\examples{
data(test_dataset_no_hypos)
recon = tronco.caprese(test_dataset_no_hypos)

}
