% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{tronco.kfold.posterr}
\alias{tronco.kfold.posterr}
\title{tronco.kfold.posterr. For details and examples 
regarding the statistical assesment of an inferred model, 
we refer to the Vignette Section 7.}
\usage{
tronco.kfold.posterr(
  x,
  models = names(as.models(x)),
  events = as.events(x),
  runs = 10,
  k = 10,
  cores.ratio = 1,
  silent = FALSE
)
}
\arguments{
\item{x}{A reconstructed model (the output of tronco.capri)}

\item{models}{The names of the selected regularizers (bic, aic or caprese)}

\item{events}{a list of event}

\item{runs}{a positive integer number, the number of times cross-validation will be run}

\item{k}{a positive integer number, the number of groups into which the data will be split}

\item{cores.ratio}{Percentage of cores to use. coresRate * (numCores - 1)}

\item{silent}{A parameter to disable/enable verbose messages.}
}
\description{
Perform a k-fold cross-validation using the function bn.cv
and scan every node to estimate its posterior classification error.
}
\examples{
data(test_model)
tronco.kfold.posterr(test_model, k = 2, runs = 2, cores.ratio = 0)

}
