% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ularcirc.R
\name{Compatible_Annotation_DBs}
\alias{Compatible_Annotation_DBs}
\title{Compatible_Annotation_DBs}
\usage{
Compatible_Annotation_DBs(search_term = "")
}
\arguments{
\item{search_term}{: character string of a full or part name of a database.
Will return only those entries that contain this search term. Not case
sensitive.}
}
\value{
Returns a list of compatible annotation databases
}
\description{
Interogates Bioconductor databases and identifies those that are compatible
with Ularcirc. Builds a list of commands that the user can copy to install the
required database on their local computer. Once installed the databases are
immediately available to Ularcirc upon re-starting the shiny app.
This function requires connection to the internet.
}
\examples{
# Get all Bioconductor annotation databases that are compatible with Ularcirc
library('BSgenome')
library('httpuv')
library('AnnotationHub')
# Prepare a dataframe of all compatible annotation databases
\dontrun{ compatible_DBs_human <- Compatible_Annotation_DBs("Hsapiens")

# Example of how to find a relevant database and load the relevant databases:
# This example find hg38 databases
   idx <- grep(pattern="hg38", x= compatible_DBs_human[,"genome"])

   if (!requireNamespace("BiocManager", quietly=TRUE))
       install.packages("BiocManager")
	  BiocManager::install(c(compatible_DBs[idx,]))
	  }

}
