% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{MultiFactor}
\alias{MultiFactor}
\alias{asMultiFactor}
\title{MultiFactor S7 container class}
\usage{
MultiFactor(x, levels = NULL, drop.unmatched = FALSE)

## Constructor for `MultiFactor` objects
MultiFactor(x, levels = NULL, drop.unmatched = FALSE)
}
\arguments{
\item{x}{\code{MultiFactor}}

\item{levels}{an optional named list of vectors of the unique values (as
character strings) that x might have taken. The default is the unique set
of values taken by lapply(x, as.character), sorted into increasing order
of x.}

\item{drop.unmatched}{\verb{Logical scalar} If \code{TRUE} (Default), for feature types
that are seen at least twice, exclude features that only present in one
of their respective link data frames.}
}
\value{
a MultiFactor object.
}
\description{
\code{MultiFactor} is an S7 class to organize and manage multiple sets of factors,
for instance when tracing or converting feature IDs across databases. Methods
for \code{MultiFactor} aim to follow \code{factor} behaviour.
}
\details{
The most straightforward way to construct a \code{MultiFactor} object is as a
named list of named data.frames. The columns of the data.frames indicate the
category of factor in that column.

A \code{MultiFactor} object presents itself similar to a \code{data.frame}, in the
sense that level types can be called as columns and individual data.frame
components can be called as rows.
}
\section{Slots}{

\describe{
\item{\code{index}}{Named \code{list} of named integer data frames of at least two columns
each. The column names correspond to names in the \code{levels} slot. Similar
to \code{factor}s, the integers in those columns correspond to the characters
in that level. Accessed through regular list methods (e.g., \code{[}, \code{[[}).}

\item{\code{levels}}{\verb{Named list of character vectors}. Accessed through \code{levels(x)}}

\item{\code{map}}{\verb{(sparse) Matrix} specifying which elements contain which levels.
Accesses through \code{x@dictionary}.}
}}

\examples{
# Generate some random linkage input
x <- data.frame(
    a = sample(letters[seq(3)], 10, replace = TRUE),
    A = sample(LETTERS[seq(3)], 10, replace = TRUE)
)
MultiFactor(x)

}
\seealso{
\code{\link[=MultiFactor-methods]{MultiFactor-methods()}}

\itemize{
\item \code{\link[=kegg_link]{kegg_link()}}: for an example of valid input.
}
}
