% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichViewNet.R
\docType{package}
\encoding{UTF-8}
\name{enrichViewNet-package}
\alias{enrichViewNet-package}
\alias{enrichViewNet}
\title{From functional enrichment results to biological networks}
\description{
The \code{enrichViewNet} package enables the visualization 
of enrichment results, in a format corresponding to the one generated 
by \code{gprofiler2} 
(\url{https://cran.r-project.org/web/packages/gprofiler2/index.html})  
under the form of \code{Cytoscape} network (\url{https://cytoscape.org/}).
}
\details{
In those networks, both gene datasets (GO terms/pathways/protein complexes)
and genes are represented as nodes. A edge connect a gene to its datasets.
In the current version, only genes present in at least one gene dataset 
are retained.
}
\seealso{
\itemize{
    \item{\code{\link{createNetwork}} for transforming functional 
    enrichment results from gprofiler2 into a Cytoscape network}
    \item{\code{\link{createEnrichMap}} for transforming functional 
    enrichment results from gprofiler2 into an enrichment map in 
    ggplot format}
    \item{\code{\link{createEnrichMapAsIgraph}} for transforming functional 
    enrichment results from gprofiler2 into an enrichment map in 
    igraph format}
    \item{\code{\link{createEnrichMapMultiComplex}} for transforming 
    functional enrichment results from multiple gprofiler2 enrichment 
    results into an enrichment map in ggplot format}
    \item{\code{\link{createEnrichMapMultiComplexAsIgraph}} for transforming 
    functional enrichment results from multiple gprofiler2 enrichment 
    results into an enrichment map in igraph format}
}
}
\author{
Astrid Deschênes, Pascal Belleau, Robert L Faure,  
Maria J Fernandes, David A Tuveson

Maintainer:
Astrid Deschênes <adeschen@hotmail.com>
}
\keyword{package}
