% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{faers_download}
\alias{faers_download}
\title{Download FAERS data}
\usage{
faers_download(years, quarters, format = NULL, dir = getwd(), ...)
}
\arguments{
\item{years}{An atomic integer indicates years for which data are required.}

\item{quarters}{An atomic character, only "q1", "q2", "q3", and "q4" are
allowed.}

\item{format}{File format to used, only "ascii" and "xml" are availabe.
Default: "ascii".}

\item{dir}{The destination directory for any downloads. Defaults to
current working dir.}

\item{...}{Extra handle options passed to each request
\link[curl:multi_download]{multi_download}.}
}
\value{
An atomic character for the path of downloaded files.
}
\description{
This function downloads the FAERS data for selected years and quarters.
}
\examples{
# you must change `dir`, as the file included in the package is sampled
# in this way, the file will downloaded from FAERS
faers_download(
    year = 2004, quarter = "q1",
    dir = system.file("extdata", package = "faers")
)
}
