% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal.R
\name{faers_phv_signal}
\alias{faers_phv_signal}
\alias{faers_phv_table}
\alias{faers_phv_table,FAERSascii,FAERSascii,missing-method}
\alias{faers_phv_table,FAERSascii,missing,FAERSascii-method}
\alias{faers_phv_signal,FAERSascii-method}
\title{Create contingency table and run disproportionality analysis}
\usage{
faers_phv_table(.object, ..., .full, .object2)

\S4method{faers_phv_table}{FAERSascii,FAERSascii,missing}(.object, .events = "soc_name", ..., .full, .object2)

\S4method{faers_phv_table}{FAERSascii,missing,FAERSascii}(.object, .events = "soc_name", ..., .full, .object2)

faers_phv_signal(.object, ...)

\S4method{faers_phv_signal}{FAERSascii}(
  .object,
  .methods = NULL,
  ...,
  .phv_signal_params = list(),
  BPPARAM = SerialParam()
)
}
\arguments{
\item{.object}{A \link{FAERSascii} object. The unique number of \code{primaryids} from
\code{.object} will be regarded as \code{n1.}.}

\item{...}{Other arguments passed to specific methods.
\itemize{
\item \code{faers_phv_table}: other arguments passed to \link{faers_counts}.
\item \code{faers_phv_signal}: other arguments passed to \code{faers_phv_table}.
}}

\item{.full}{A \link{FAERSascii} object with data from full data. In this way,
\code{.object} must be a subset of \code{.full}. The unique number of \code{primaryids} from
\code{.full} will be regarded as \code{n}.}

\item{.object2}{A \link{FAERSascii} object with data from another interested drug,
In this way, \code{.object} and \code{.object2} should not be overlapped. The unique
number of \code{primaryids} from \code{object2} will be regarded as \code{n0.}.}

\item{.events}{A character specify the events column(s) in the \code{.field} data
to count the unique \code{primaryid}. If multiple columns were selected, the
combination for all columns will define the interested events.}

\item{.methods}{Just an alias of \code{method} in \link{phv_signal}.}

\item{.phv_signal_params}{Other arguments passed to \link{phv_signal}.}

\item{BPPARAM}{An optional \code{\link[BiocParallel]{BiocParallelParam}} instance
    defining the parallel back-end to be used during evaluation.
  }
}
\value{
A \link[data.table:data.table]{data.table} object.
}
\description{
Create contingency table and run disproportionality analysis
}
\details{
\itemize{
\item \code{faers_phv_table}: build a contingency table for all events in
\code{.events}.
\item \code{faers_phv_signal}: Pharmacovigilance Analysis used contingency table
constructed with \code{faers_phv_table}. You must pass \code{.full} or \code{.object2}
into \code{faers_phv_table}.
}
}
\examples{
# you must change `dir`, as the files included in the package are sampled
data <- faers(c(2004, 2017), c("q1", "q2"),
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
\dontrun{
# you must standardize and deduplication before disproportionality analysis
# you should replace `meddra_path` with yours
data <- faers_standardize(data, meddra_path)
data <- faers_dedup(data)
# we use faers_filter() to extract data we are interested
# here, we just sample 100 reports. You should do it based on your purpose.
faers_phv_signal(
    faers_filter(data, .fn = ~ sample(faers_primaryid(.x), 100L)),
    .full = data
)
}
}
\seealso{
\link{phv_signal}
}
