% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist2tree.R
\name{dist2tree}
\alias{dist2tree}
\title{Generate phylogenetic tree from samples of a distance matrix}
\usage{
dist2tree(inputDist, verbose = FALSE)
}
\arguments{
\item{inputDist}{Input distances file location
(generated with \code{\link[fastreeR]{vcf2dist}}
or \code{\link[fastreeR]{fasta2dist}}).
File can be gzip compressed.
Or a \code{\link[stats]{dist}} distances object.}

\item{verbose}{Logical. If TRUE, enables verbose output from the Java backend.}
}
\value{
A \code{\link[base]{character} vector} of the generated
phylogenetic tree in Newick format.
}
\description{
Performs Hierarchical Clustering on a distance matrix
(i.e. calculated with \code{\link[fastreeR]{vcf2dist}}
or \code{\link[fastreeR]{fasta2dist}})
and generates a phylogenetic tree with
agglomerative Neighbor Joining method (complete linkage).
}
\examples{
my.tree <- dist2tree(
    inputDist =
    system.file("extdata", "samples.vcf.dist.gz", package = "fastreeR"),
    verbose = TRUE
)
}
\references{
Java implementation:
\url{https://github.com/gkanogiannis/BioInfoJava-Utils}
}
\author{
Anestis Gkanogiannis, \email{anestis@gkanogiannis.com}
}
