% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgseaMultilevel.R
\name{fgseaMultilevel}
\alias{fgseaMultilevel}
\title{Runs preranked gene set enrichment analysis.}
\usage{
fgseaMultilevel(
  pathways,
  stats,
  sampleSize = 101,
  minSize = 1,
  maxSize = length(stats) - 1,
  eps = 1e-50,
  scoreType = c("std", "pos", "neg"),
  nproc = 0,
  gseaParam = 1,
  BPPARAM = NULL,
  nPermSimple = 1000,
  absEps = NULL
)
}
\arguments{
\item{pathways}{List of gene sets to check.}

\item{stats}{Named vector of gene-level stats. Names should be the same as in 'pathways'}

\item{sampleSize}{The size of a random set of genes which in turn has size = pathwaySize}

\item{minSize}{Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{maxSize}{Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{eps}{This parameter sets the boundary for calculating the p value.}

\item{scoreType}{This parameter defines the GSEA score type.
Possible options are ("std", "pos", "neg").
By default ("std") the enrichment score is computed as in the original GSEA.
The "pos" and "neg" score types are intended to be used for one-tailed tests
(i.e. when one is interested only in positive ("pos") or negateive ("neg") enrichment).}

\item{nproc}{If not equal to zero sets BPPARAM to use nproc workers (default = 0).}

\item{gseaParam}{GSEA parameter value, all gene-level statis are raised to the power of `gseaParam`
before calculation of GSEA enrichment scores.}

\item{BPPARAM}{Parallelization parameter used in bplapply.
Can be used to specify cluster to run. If not initialized explicitly or
by setting `nproc` default value `bpparam()` is used.}

\item{nPermSimple}{Number of permutations in the simple fgsea implementation
for preliminary estimation of P-values.}

\item{absEps}{deprecated, use `eps` parameter instead}
}
\value{
A table with GSEA results. Each row corresponds to a tested pathway. The columns are the following
\itemize{
\item pathway -- name of the pathway as in `names(pathway)`;
\item pval -- an enrichment p-value;
\item padj -- a BH-adjusted p-value;
\item log2err -- the expected error for the standard deviation of the P-value logarithm.
\item ES -- enrichment score, same as in Broad GSEA implementation;
\item NES -- enrichment score normalized to mean enrichment of random samples of the same size;
\item size -- size of the pathway after removing genes not present in `names(stats)`.
\item leadingEdge -- vector with indexes of leading edge genes that drive the enrichment, see \url{http://software.broadinstitute.org/gsea/doc/GSEAUserGuideTEXT.htm#_Running_a_Leading}.
}
}
\description{
This feature is based on the adaptive multilevel splitting Monte Carlo approach.
This allows us to exceed the results of simple sampling and calculate arbitrarily small P-values.
}
\examples{
data(examplePathways)
data(exampleRanks)
fgseaMultilevelRes <- fgseaMultilevel(examplePathways, exampleRanks, maxSize=500)
}
