% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathways.R
\name{mapIdsList}
\alias{mapIdsList}
\title{Effeciently converts collection of pathways using AnnotationDbi::mapIds function. Parameters
are the sames as for mapIds except for keys, which is assumed to be a list of vectors.}
\usage{
mapIdsList(x, keys, column, keytype, ...)
}
\arguments{
\item{x}{the AnnotationDb object. But in practice this will mean an object derived from an AnnotationDb object such as a OrgDb or ChipDb object.}

\item{keys}{a list of vectors with gene ids}

\item{column}{the column to search on}

\item{keytype}{the keytype that matches the keys used}

\item{...}{other parameters passed to AnnotationDbi::mapIds}
}
\description{
Effeciently converts collection of pathways using AnnotationDbi::mapIds function. Parameters
are the sames as for mapIds except for keys, which is assumed to be a list of vectors.
}
\examples{
library(org.Mm.eg.db)
data(exampleRanks)
fgseaRes <- fgsea(examplePathways, exampleRanks, maxSize=500, eps=1e-4)
fgseaRes[, leadingEdge := mapIdsList(org.Mm.eg.db, keys=leadingEdge, column="SYMBOL", keytype="ENTREZID")]
}
\seealso{
AnnotationDbi::mapIds
}
