\name{delete.attr.gdsn}
\alias{delete.attr.gdsn}
\title{Delete attribute(s)}
\description{
    Remove the attribute(s) of a GDS node.
}

\usage{
delete.attr.gdsn(node, name)
}
\arguments{
    \item{node}{an object of class \code{\link{gdsn.class}}, a GDS node}
    \item{name}{the name(s) of an attribute}
}
\value{
    None.
}

\author{Xiuwen Zheng}
\seealso{
    \code{\link{put.attr.gdsn}}, \code{\link{get.attr.gdsn}}
}

\examples{
# cteate a GDS file
f <- createfn.gds("test.gds")

node <- add.gdsn(f, "int", val=1:10000)
put.attr.gdsn(node, "missing.value", 10000)
put.attr.gdsn(node, "one.value", 1L)
put.attr.gdsn(node, "string", c("ABCDEF", "THIS"))
put.attr.gdsn(node, "bool", c(TRUE, TRUE, FALSE))

f
get.attr.gdsn(node)

delete.attr.gdsn(node, c("one.value", "bool"))
get.attr.gdsn(node)

# close the GDS file
closefn.gds(f)


# delete the temporary file
unlink("test.gds", force=TRUE)
}

\keyword{GDS}
\keyword{utilities}
