% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecation.R
\name{search_datasets}
\alias{search_datasets}
\title{Retrieve datasets associated to an annotation tags search}
\usage{
search_datasets(
  query,
  taxon = NA_character_,
  offset = 0L,
  limit = 20L,
  sort = "+id",
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE),
  attributes = getOption("gemma.attributes", TRUE),
  ...
)
}
\arguments{
\item{query}{The search query. Either plain text ('traumatic'), or an ontology term URI ('http://purl.obolibrary.org/obo/UBERON_0002048'). Datasets that contain the given string in their short
or full name will also be matched. Can be multiple identifiers separated by commas.}

\item{taxon}{Can either be Taxon ID, Taxon NCBI ID, or one of its string identifiers: scientific name, common name.
It is recommended to use Taxon ID for efficiency.
Please note, that not all taxa have all the possible identifiers available.
Use the \code{\link{get_taxa_by_ids}} function to retrieve the necessary information. For convenience, below is a list of officially supported taxa:
\tabular{rllr}{
\strong{ID} \tab \strong{Comm.name} \tab \strong{Scient.name}    \tab \strong{NcbiID}\cr
1            \tab human               \tab Homo sapiens             \tab 9606            \cr
2            \tab mouse               \tab Mus musculus             \tab 10090           \cr
3            \tab rat                 \tab Rattus norvegicus        \tab 10116           \cr
11           \tab yeast               \tab Saccharomyces cerevisiae \tab 4932            \cr
12           \tab zebrafish           \tab Danio rerio              \tab 7955            \cr
13           \tab fly                 \tab Drosophila melanogaster  \tab 7227            \cr
14           \tab worm                \tab Caenorhabditis elegans   \tab 6239
}}

\item{offset}{The offset of the first retrieved result.}

\item{limit}{Optional, defaults to 20. Limits the result to specified amount
of objects. Has a maximum value of 100. Use together with \code{offset} and
the \code{totalElements} \link[base:attributes]{attribute} in the output to
compile all data if needed.}

\item{sort}{Order results by the given property and direction. The '+' sign indicate ascending order whereas the '-' indicate descending.}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be a JSON file. Otherwise,
it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}

\item{attributes}{If \code{TRUE} additional information from the call will be added
into the output object's attributes such as offset and available elements.}

\item{...}{Kept for compatibility, ignored.}
}
\value{
A data table with information about the queried dataset(s). A list if
\code{raw = TRUE}. Returns an empty list if no datasets matched.

The fields of the output data.table are:

\itemize{
\item \code{experiment.shortName}: Shortname given to the dataset within Gemma. Often corresponds to accession ID
\item \code{experiment.name}: Full title of the dataset
\item \code{experiment.ID}: Internal ID of the dataset.
\item \code{experiment.description}: Description of the dataset
\item \code{experiment.troubled}: Did an automatic process within gemma or a curator mark the dataset as "troubled"
\item \code{experiment.accession}: Accession ID of the dataset in the external database it was taken from
\item \code{experiment.database}: The name of the database where the dataset was taken from
\item \code{experiment.URI}: URI of the original database
\item \code{experiment.sampleCount}: Number of samples in the dataset
\item \code{experiment.batchEffectText}: A text field describing whether the dataset has batch effects
\item \code{experiment.batchCorrected}: Whether batch correction has been performed on the dataset.
\item \code{experiment.batchConfound}: 0 if batch info isn't available, -1 if batch counfoud is detected, 1 if batch information is available and no batch confound found
\item \code{experiment.batchEffect}: -1 if batch p value < 0.0001, 1 if batch p value > 0.1, 0 if otherwise and when there is no batch information is available or when the data is confounded with batches.
\item \code{experiment.rawData}: -1 if no raw data available, 1 if raw data was available. When available, Gemma reprocesses raw data to get expression values and batches
\item \code{geeq.qScore}: Data quality score given to the dataset by Gemma.
\item \code{geeq.sScore}: Suitability score given to the dataset by Gemma. Refers to factors like batches, platforms and other aspects of experimental design
\item \code{taxon.name}: Name of the species
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underyling database used in Gemma for the taxon
}
}
\description{
This function is deprecated in favor of \code{\link{get_datasets}}
}
\examples{
search_datasets("bipolar", taxon = "human")
}
\keyword{internal}
