% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctiModMix2SE.R
\name{fctiModMix2SE}
\alias{fctiModMix2SE}
\title{fctiModMix2SE}
\usage{
fctiModMix2SE(dataExp, metadata)
}
\arguments{
\item{dataExp}{A data frame with metabolites (features) in rows and samples in columns.
The first column should contain feature IDs (e.g., metabolite names).}

\item{metadata}{A data frame containing sample metadata.
Must include a column named "Sample" that matches the column names of \code{dataExp}
(excluding the first column).}
}
\value{
A \code{SummarizedExperiment} object.
}
\description{
Converts expression data and corresponding sample metadata
into a Bioconductor-compliant SummarizedExperiment object.
}
\examples{
dataExp <- data.frame(Feature_ID = paste0("M", 1:5),
                      S1 = rnorm(5), S2 = rnorm(5))
metadata <- data.frame(Sample = c("S1", "S2"),
                       Group = c("A", "B"))
se <- fctiModMix2SE(dataExp, metadata)
se
}
