% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distToCells.R
\name{distToCells}
\alias{distToCells}
\title{Function to calculate distance to cells of interest}
\usage{
distToCells(
  object,
  x_cells,
  img_id,
  name = "distToCells",
  coords = c("Pos_X", "Pos_Y"),
  statistics = "min",
  return_neg = TRUE,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{object}{a \code{SingleCellExperiment} or \code{SpatialExperiment}
object}

\item{x_cells}{logical vector of length equal to the number of cells
contained in \code{object}. \code{TRUE} entries define the cells to which
distances will be calculated.}

\item{img_id}{single character indicating the \code{colData(object)} entry
containing the unique image identifiers.}

\item{name}{character specifying the name of the \code{colData} entry to safe
the distances in.}

\item{coords}{character vector of length 2 specifying the names of the
\code{colData} (for a \code{SingleCellExperiment} object) or the
\code{spatialCoords} entries of the cells' x and y locations.}

\item{statistics}{one of "min", "max", "mean" or "meadian" specifying the distance statistics to use when computing
the distances.}

\item{return_neg}{logical indicating whether negative distances are to be
returned for the distances of patched/spatially clustered cells.}

\item{BPPARAM}{a \code{\link[BiocParallel]{BiocParallelParam-class}} object
defining how to parallelize computations.}
}
\value{
returns an object of \code{class(object)} containing a new column
entry to \code{colData(object)[[name]]}. Cells in the object are grouped
by entries in \code{img_id}.
}
\description{
Function to return the min, max, mean or median distance to the cells of interest
for each cell in the data. In the case of patched/clustered cells negative
distances are returned by default which indicate the distance of the cells
of interest to the cells that are not of the type of cells of
interest.
}
\section{Ordering of the output object}{

The \code{minDistToCells} function operates on individual images.
Therefore the returned object is grouped by entries in \code{img_id}.
This means all cells of a given image are grouped together in the object.
The ordering of cells within each individual image is the same as the ordering
of these cells in the input object.
}

\examples{
library(cytomapper)
data(pancreasSCE)

# Build interaction graph
pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb",
type = "expansion",threshold = 20)

# Detect patches of "celltype_B" cells
pancreasSCE <- patchDetection(pancreasSCE,
                             img_id = "ImageNb",
                             patch_cells = pancreasSCE$CellType == "celltype_B",
                             colPairName = "expansion_interaction_graph",
                             min_patch_size = 20,
                             expand_by = 1)

plotSpatial(pancreasSCE,
            img_id = "ImageNb",
            node_color_by = "patch_id",
            scales = "free")

# Distance to celltype_B patches
pancreasSCE <- distToCells(pancreasSCE,
                             x_cells = !is.na(pancreasSCE$patch_id),
                             coords = c("Pos_X","Pos_Y"),
                             statistics = "min",
                             img_id = "ImageNb")

plotSpatial(pancreasSCE,
            img_id = "ImageNb",
            node_color_by = "distToCells",
            scales = "free")

}
\author{
Daniel Schulz & Bruno Palau (\email{daniel.schulz@uzh.ch})
}
