% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{mply_dbl}
\alias{mply_dbl}
\alias{stack_rows}
\alias{stack_cols}
\title{Iterating function that returns a matrix}
\usage{
mply_dbl(x, FUN, ncol = 1, ...)

stack_rows(x)

stack_cols(x)
}
\arguments{
\item{x}{the sequence that is mapped to a matrix}

\item{FUN}{the function that returns a vector of length \code{ncol}}

\item{ncol}{the length of the output vector}

\item{...}{additional arguments that are passed to \code{FUN}}
}
\value{
A matrix with \code{length(x)} / \code{nrow(x)} rows and \code{ncol} columns.
For \code{msply_dbl} the number of columns depends on the output of \code{FUN}.
}
\description{
The length of \code{x} determines the number of rows. The length of
\code{FUN(x[i])} determines the number of columns. Must match \code{ncol}.
}
\section{Functions}{
\itemize{
\item \code{stack_rows()}: Each list element becomes a row in a matrix

\item \code{stack_cols()}: Each list element becomes a row in a matrix

}}
\keyword{internal}
