% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_de.R
\name{test_de}
\alias{test_de}
\title{Predict log fold changes between conditions for each cell}
\usage{
test_de(
  fit,
  contrast,
  embedding = NULL,
  consider = c("embedding+linear", "embedding", "linear"),
  new_assay_name = "DE"
)
}
\arguments{
\item{fit}{the result of calling \code{\link[=lemur]{lemur()}}}

\item{contrast}{Specification of the contrast: a call to \code{cond()} specifying a full observation
(e.g. \code{cond(treatment = "A", sex = "male") - cond(treatment = "C", sex = "male")} to
compare treatment A vs C for male observations). Unspecified factors default to the reference level.}

\item{embedding}{matrix of size \code{n_embedding} \eqn{\times} \code{n} that specifies where in the latent space
the differential expression is tested. It defaults to the position of all cells from the original fit.}

\item{consider}{specify which part of the model are considered for the differential expression test.}

\item{new_assay_name}{the name of the assay added to the \code{fit} object. Default: \code{"DE"}.}
}
\value{
If \code{is.null(embedding)} the \code{fit} object with a new assay called \code{"DE"}. Otherwise
return a matrix with the differential expression values.
}
\description{
Predict log fold changes between conditions for each cell
}
\examples{
library(SummarizedExperiment)
library(SingleCellExperiment)

data(glioblastoma_example_data)
fit <- lemur(glioblastoma_example_data, design = ~ patient_id + condition,
             n_emb = 5, verbose = FALSE)
# Optional alignment
# fit <- align_harmony(fit)
fit <- test_de(fit, contrast = cond(condition = "panobinostat") - cond(condition = "ctrl"))

# The fit object contains a new assay called "DE"
assayNames(fit)

# The DE assay captures differences between conditions
is_ctrl_cond <- fit$colData$condition == "ctrl"
mean(logcounts(fit)[1,!is_ctrl_cond]) - mean(logcounts(fit)[1,is_ctrl_cond])
mean(assay(fit, "DE")[1,])

}
\seealso{
\link{find_de_neighborhoods}
}
