% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genome_annotation.R
\name{annotateGRanges}
\alias{annotateGRanges}
\title{Annotate GRanges}
\usage{
annotateGRanges(
  genomic_regions,
  annotation_ranges,
  ignore.strand = TRUE,
  overlap_measure = "absolute"
)
}
\arguments{
\item{genomic_regions}{A GRanges object to be annotated}

\item{annotation_ranges}{A GRangesList object with GRanges for different features e.g. introns, exons, enhancers.}

\item{ignore.strand}{TRUE or FALSE indicating whether strand should be ignored when calculating intersections. Default is TRUE.}

\item{overlap_measure}{One of "absolute", "proportion" or "jaccard" indicating whether to calculate
the absolute size of the intersection in base pairs, the proportion of base pairs of
genomic_ranges overlapping one of the component GRanges of annotation_ranges.
or the Jaccard index of the intersection in terms of base pairs. Default value is "absolute".}
}
\value{
A numeric vector with the overlap measure for genomic_regions with each type of region in annotation_ranges.
}
\description{
Annotate GRanges
}
\examples{

# Load annotation for CpG islands and repetitive DNA
data(hg38_cpg_islands, package = "methodical")
hg38_cpg_islands <- hg38_cpg_islands[hg38_cpg_islands$type == "hg38_cpg_islands"]
repeat_annotation_hg38 <- AnnotationHub::AnnotationHub()[["AH99003"]]

# Convert repeat_annotation_hg38 into a GRangesList
repeat_annotation_hg38 <- GRangesList(split(repeat_annotation_hg38, repeat_annotation_hg38$repClass))
 
# Calculate the proportion of base pairs in CpG islands overlapping different classes of repetitive elements
annotateGRanges(genomic_regions = hg38_cpg_islands, annotation_ranges = repeat_annotation_hg38, overlap_measure = "proportion")

}
