% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plotTMRs}
\alias{plotTMRs}
\title{Add TMRs to a methylation site value plot}
\usage{
plotTMRs(
  meth_site_plot,
  tmrs_gr,
  reference_tss = NULL,
  transcript_id = NULL,
  tmr_colours = c("#A28CB1", "#D2C465"),
  linewidth = 5
)
}
\arguments{
\item{meth_site_plot}{A plot of Value around a TSS.}

\item{tmrs_gr}{A GRanges object giving the position of TMRs.}

\item{reference_tss}{An optional GRanges object with a single range. If provided, the x-axis will
show the distance of methylation sites to the start of this region with methylation sites upstream
relative to the reference_tss shown first. If not, the x-axis will show the start site coordinate of the methylation site.}

\item{transcript_id}{An optional transcript ID. If provided, will attempt to filter tmrs_gr and reference_tss using a metadata column called transcript_id with
a value identical to the provided one.}

\item{tmr_colours}{A vector with colours to use for negative and positive TMRs. Defaults to "#7B5C90" for negative and "#BFAB25" for positive TMRs.}

\item{linewidth}{A numeric value to be provided as linewidth for geom_segment().}
}
\value{
A ggplot object
}
\description{
Add TMRs to a methylation site value plot
}
\examples{
# Load methylation-transcript correlation results for TUBB6 gene
data("tubb6_cpg_meth_transcript_cors", package = "methodical")

# Plot methylation-transcript correlation values around TUBB6 TSS
tubb6_correlation_plot <- methodical::plotMethSiteCorCoefs(tubb6_cpg_meth_transcript_cors, ylabel = "Spearman Correlation")
  
# Find TMRs for TUBB6
tubb6_tmrs <- findTMRs(correlation_list = list(ENST00000591909 = tubb6_cpg_meth_transcript_cors))

# Plot TMRs on top of tubb6_correlation_plot
methodical::plotTMRs(tubb6_correlation_plot, tmrs_gr = tubb6_tmrs)
}
