% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotTree.R
\name{plotRowTree}
\alias{plotRowTree}
\alias{plotColTree}
\alias{plotTree}
\alias{plotColTree,TreeSummarizedExperiment-method}
\alias{plotRowTree,TreeSummarizedExperiment-method}
\title{Plotting tree information enriched with information}
\usage{
plotRowTree(x, ...)

plotColTree(x, ...)

\S4method{plotColTree}{TreeSummarizedExperiment}(x, tree.name = "phylo", ...)

\S4method{plotRowTree}{TreeSummarizedExperiment}(x, tree.name = "phylo", ...)
}
\arguments{
\item{x}{a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{additional arguments for plotting.
\itemize{
\item \code{layout}: layout for the plotted tree. See
\code{\link[ggtree:ggtree]{ggtree}} for details.

\item \code{relabel.tree}: \code{Logical scalar}. Should the tip labels be
relabelec using the output of
\code{getTaxonomyLabels(x, with_rank = TRUE)}? (Default: \code{FALSE})

\item \code{order.tree}: \code{Logical scalar}. Should the tree be ordered
based on alphabetic order of taxonomic levels? (Default: \code{FALSE})

\item \code{levels.rm}: \code{Logical scalar}. Should taxonomic level
information be removed from labels? (Default: \code{FALSE})

\item \code{show.label}, \code{show.highlights},
\code{show.highlight.label}, \code{abbr.label} \code{logical vector},
\code{integer vector}. or \code{character vector}. If a \code{logical}
scalar is given, should tip labels be plotted or if a
logical vector is provided, which labels should be shown? If an
\code{integer} or \code{character} vector is provided, it will be converted
to a logical vector. The \code{integer} values must be in the range of 1
and number of nodes, whereas the values of a \code{character} vector must
match values of the \code{label} column in the node data. In case of a
\code{character} vector only values corresponding to actual labels will be
plotted and if no labels are provided no labels will be shown. (Default:
\code{FALSE})

\item \code{add.legend}: \code{Logical scalar}. Should legends be plotted?
(Default: \code{TRUE})

\item \code{edge.colour.by}: \code{Character scalar}. Specification of a
column metadata field or a feature to colour tree edges by.
(Default: \code{NULL})

\item \code{edge.size.by}: \code{Character scalar}. Specification of a
column metadata field or a feature to size tree edges by.
(Default: \code{NULL})

\item \code{colour.by}: \code{Character scalar}. Specification of a
column metadata field or a feature to colour tree nodes by.
(Default: \code{NULL})

\item \code{shape.by}: \code{Character scalar}. Specification of a
column metadata field or a feature to shape tree nodes by.
(Default: \code{NULL})

\item \code{size.by}: \code{Character scalar}. Specification of a
column metadata field or a feature to size tree tips by.
(Default: \code{NULL})

\item \code{show.tips}: \code{Logical scalar}. Whether to show
tip points. (Default: \code{FALSE})

\item \code{show.nodes}: \code{Logical scalar}. Whether to show
node points. (Default: \code{FALSE})

\item \code{colour.highlights.by}: \code{Logical scalar}. Should the
highlights be colour differently? If \code{show.highlights = TRUE},
\code{colour_highlights} will be set to \code{TRUE} as default.
(Default: \code{FALSE})

\item \code{assay.type}: \code{Character scalar}. Specifies which assay to
obtain expression values from, for use in point aesthetics.
(Default: \code{"counts"})

\item \code{other.fields}: \code{Character vector}. Additional fields to
include in the node information without plotting them.
(Default: \code{NULL})
}}

\item{tree.name}{\code{Character scalar}. Specifies a rowTree/colTree from
\code{x}. (Default: \code{tree.name = "phylo"})}
}
\value{
a \code{\link{ggtree}} plot
}
\description{
Based on the stored data in a \code{TreeSummarizedExperiment} a tree can
be plotted. From the \code{rowData}, the \code{assays} as well as the
\code{colData} information can be taken for enriching the tree plots with
additional information.
}
\details{
If \code{show.label} or \code{show.highlight.label} have the same length
as the number of nodes, the vector will be used to relabel the nodes.
}
\examples{
library(scater)
library(mia)
# preparation of some data
data(GlobalPatterns)
GlobalPatterns <- agglomerateByRanks(GlobalPatterns)
altExp(GlobalPatterns,"Genus") <- addPerFeatureQC(
    altExp(GlobalPatterns,"Genus"))
rowData(altExp(GlobalPatterns,"Genus"))$log_mean <- log(
    rowData(altExp(GlobalPatterns,"Genus"))$mean)
rowData(altExp(GlobalPatterns,"Genus"))$detected <- rowData(
    altExp(GlobalPatterns,"Genus"))$detected / 100
top_genus <- getTop(
    altExp(GlobalPatterns,"Genus"),
    method = "mean",
    top = 100L,
    assay.type = "counts"
)
#
x <- altExp(GlobalPatterns,"Genus")
plotRowTree(
    x[rownames(x) \%in\% top_genus,],
    tip.colour.by = "log_mean", tip.size.by = "detected"
)

# plot with tip labels
plotRowTree(
    x[rownames(x) \%in\% top_genus,],
    tip.colour.by = "log_mean",
    tip.size.by = "detected",
    show.label = TRUE
)
# plot with selected labels
labels <- c("Genus:Providencia", "Genus:Morganella", "0.961.60")
plotRowTree(
    x[rownames(x) \%in\% top_genus,],
    tip.colour.by = "log_mean",
    tip.size.by = "detected",
    show.label = labels,
    layout = "rectangular"
)

# plot with labeled edges
plotRowTree(
    x[rownames(x) \%in\% top_genus,],
    edge.colour.by = "Phylum",
    tip.colour.by = "log_mean"
)
# if edges are sized, colours might disappear depending on plotting device
plotRowTree(
    x[rownames(x) \%in\% top_genus,],
    node.colour.by = "Phylum",
    edge.size.by = "detected",
    edge.colour.by = "log_mean"
)

# aggregating data over the taxonomic levels for plotting a taxonomic tree
# please note that the original tree of GlobalPatterns is dropped by
# unsplitByRanks
altExps(GlobalPatterns) <- splitByRanks(GlobalPatterns)
top_phyla <- getTop(
    altExp(GlobalPatterns,"Phylum"),
    method = "mean",
    top = 10L,
    assay.type="counts"
)
altExps(GlobalPatterns) <- lapply(altExps(GlobalPatterns), addPerFeatureQC)
altExps(GlobalPatterns) <- lapply(
    altExps(GlobalPatterns), function(y){
        rowData(y)$log_mean <- log(rowData(y)$mean)
        rowData(y)$detected <- rowData(y)$detected / 100
        return(y)
    })
x <- unsplitByRanks(GlobalPatterns)
x <- addHierarchyTree(x)

highlights <- c(
    "Phylum:Firmicutes","Phylum:Bacteroidetes",
    "Family:Pseudomonadaceae","Order:Bifidobacteriales")
plotRowTree(
    x[rowData(x)$Phylum \%in\% top_phyla,],
    tip.colour.by = "log_mean",
    node.colour.by = "log_mean",
    show.highlights = highlights,
    show.highlight.label = highlights,
    colour.highlights.by = "Phylum"
)

# If you do not want to show internal nodes
plotRowTree(
    x[rowData(x)$Phylum \%in\% top_phyla,],
    edge.colour.by = "Phylum",
    edge.size.by = "detected",
    node.colour.by = "log_mean",
    show.nodes = FALSE
)

}
\seealso{
\code{\link[mia:agglomerate-methods]{agglomerateByRanks}}
}
