% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotCompareStates}
\alias{plotCompareStates}
\title{Compare QTL between two states}
\usage{
plotCompareStates(
  object,
  x,
  y,
  assay = "betas",
  FUN = identity,
  assaySig = "significant",
  alpha = 0.2,
  colBoth = "#4477AA",
  colDiverging = "#EE6677",
  colNeither = "gray50",
  colX = "#CCBB44",
  colY = "#AA3377"
)
}
\arguments{
\item{object}{an \code{QTLExperiment} object.}

\item{x}{Name of state for x-axis}

\item{y}{Name of state for y-axis}

\item{assay}{name of assay to plot.}

\item{FUN}{Function to be applied to fillBy assay before plotting (e.g.
identity, abs, log10).}

\item{assaySig}{name of assay with TRUE/FALSE significance calls.}

\item{alpha}{Transparency.}

\item{colBoth}{Color for tests significant in both states.}

\item{colDiverging}{Color for tests significant in both states, with
diverging effect sizes.}

\item{colNeither}{Color for null tests.}

\item{colX}{Color for tests significant in the x-axis state only.}

\item{colY}{Color for tests significant in the y-axis state only.}
}
\value{
Returns a list containing the counts for each color category
        and the plot object.
}
\description{
Convenience method for comparing the assay value, specified by assay,
between two states.
}
\examples{
sim <- qtleSimulate(
    nStates=10, nFeatures=100, nTests=1000,
    global=0.2, multi=0.4, unique=0.2, k=2)
sim <- callSignificance(sim, mode="simple", assay="lfsrs", 
    thresh=0.0001, secondThresh=0.0002)
sim_sig <- getSignificant(sim)
sim_top <- getTopHits(sim_sig, assay="lfsrs", mode="state")
sim_top <- runPairwiseSharing(sim_top)
sim_top <- runTestMetrics(sim_top)
plotCompareStates(sim_top, x="S01", y="S02")

}
