#c("http://www.semanticweb.org/uned/ontologies/2018/4/NIO#SR", 
#"http://purl.obolibrary.org/obo/MF_0000202", "http://www.w3.org/2002/07/owl#topObjectProperty", 
#"http://purl.obolibrary.org/obo/OGMS_0000087")


#' extract class relationship graph from JSON representation of OWL for NIO
#' @importFrom jsonlite fromJSON
#' @import graph
#' @param jsonpath character(1) path to JSON, typically generated by java robot applied to owl
#' @param dropstrings character(), strings to be excised from class names
#' @return graphNEL with edgemode 'directed'
#' @examples
#' if (!requireNamespace("graph")) stop("install graph package from Bioconductor to use this function")
#' jpath = system.file("json", "nio.json.gz", package="ontoProc")
#' cg = jowl2classgraph_nio(jpath,
#'   dropstrings = "http://purl.org/autism-ontology/1.0/autism-rules.owl#")
#' head(graph::nodes(cg))
#' @export
jowl2classgraph_nio = function(jsonpath,
  dropstrings = NULL) {
 nio1 = fromJSON(jsonpath)
 # extract class hierarchy
 nodedf  = (nio1[[1]]$nodes[[1]])  # this has lbl values for all URIs
# end build
 edgedf  = (nio1[[1]]$edges[[1]])
 tags2use = unique(c(edgedf$sub, edgedf$obj))
 nodeok = which(nodedf$id %in% tags2use)
 nodedf = nodedf[nodeok,]
 labmap = nodedf$lbl
 names(labmap) = nodedf$id
 isas = which(edgedf$pred == "is_a")
 iedges = edgedf[isas,]
 iedges$sub = labmap[iedges$sub]
 iedges$obj = labmap[iedges$obj]
# end remap
# deal with NA after mapping
 dr = c(which(is.na(iedges$sub)), which(is.na(iedges$obj)))
 if (length(dr)>0) iedges = iedges[-dr,]
 utoks = unique(c(iedges$sub, iedges$obj))
 # remove undesirable namespace prefixes (would be nice to stash them... when we design an object)
 if (length(dropstrings)>0) {
     cl = function(x, dropstrings) {
       for (i in seq_len(length(dropstrings)))
          x = gsub(dropstrings[i], "", x)
       x
       }
    }
 else cl = function(x, dropstrings) force(x)
 # drop strings when used ... could be moved up in workstream
 autg = new("graphNEL", nodes=schk2(cl(utoks, dropstrings)), edgemode="directed")
 addEdge(schk2(cl(iedges$obj, dropstrings)), schk2(cl(iedges$sub, dropstrings)), autg)
}

#debug(jowl2classgraph)

#cg = jowl2classgraph("aut.json",
#   dropstrings = "http://purl.org/autism-ontology/1.0/autism-rules.owl#")
#plot(cg)
thi = "http://www.w3.org/2002/07/owl#Thing"

#evec = grep("span\\#|snap\\#", nodes(cg), value=TRUE)
