% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autism_details.R
\name{graph2paths}
\alias{graph2paths}
\title{produce list of vectors of (shortest) paths from root to all nodes in gr}
\usage{
graph2paths(gr, root = "http://www.ifomis.org/bfo/1.1#Entity", excise = NULL)
}
\arguments{
\item{gr}{graphNEL (package graph) instance representing an ontology}

\item{root}{character(1) node from which to produce paths}

\item{excise}{character() or NULL, path steps to exclude}
}
\description{
produce list of vectors of (shortest) paths from root to all nodes in gr
}
\examples{
if (!requireNamespace("graph")) stop("install graph package from Bioconductor to use this function")
jpath = system.file("json", "aut.json.gz", package="ontoProc")
cg = jowl2classgraph(jpath,
  dropstrings = "http://purl.org/autism-ontology/1.0/autism-rules.owl#")
evec = grep("span\\\\#|snap\\\\#", graph::nodes(cg), value=TRUE)
paths = graph2paths(cg, excise=evec)
tail(paths)
}
