% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owl_ops.R
\name{labels.owlents}
\alias{labels.owlents}
\title{retrieve labels with names}
\usage{
\method{labels}{owlents}(object, ...)
}
\arguments{
\item{object}{owlents instance}

\item{\dots}{not used}
}
\description{
retrieve labels with names
}
\note{
When multiple labels are present, only first is silently returned.  Note that reticulate 1.35.0 made a change that
appears to imply that `[0]` can be used to retrieve the desired
components.
To get ontology tags, use `names(labels(...))`.  Note: This function was revised Jul 12 2024
to allow terms that lack labels (like CHEBI references in cl.owl) to be processed, returning NA.
The previous functionality which failed is available, not exported, as labelsOLD.owlents.
}
\examples{
\dontrun{
clont_path = owl2cache(url="http://purl.obolibrary.org/obo/cl.owl")
o2 = try(reticulate::import("owlready2"), silent=TRUE)
if (!inherits(o2, "try-error")) {
 clont = setup_entities(clont_path)
 labels(clont[1:5])
 labels(clont[51:55])
}
} # dontrun introduced because of ambiguity in STATO term usage; see vignettes for repaired example
}
