% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.owlents.R
\name{plot.owlents}
\alias{plot.owlents}
\title{visualize ontology selection via onto_plot2, based on owlents}
\usage{
plot.owlents(x, y, ..., dropThing = TRUE)
}
\arguments{
\item{x}{owlents instance}

\item{y}{character() vector of entries in x$clnames}

\item{\dots}{passed to onto_plot2}

\item{dropThing}{logical(1) defaults to TRUE; if "Thing" is
present in terms to display, it is removed}
}
\description{
visualize ontology selection via onto_plot2, based on owlents
}
\examples{
cl3k = c("CL:0000492", "CL:0001054", "CL:0000236",
  "CL:0000625", "CL:0000576",
  "CL:0000623", "CL:0000451", "CL:0000556")
cl3k = gsub(":", "_", cl3k)
 clont_path = owl2cache(url="http://purl.obolibrary.org/obo/cl.owl")
tmp = readLines(clont_path)
# deal with ambiguity not accommodated by owlready2
bad = grep("STATO_0000416", tmp)[1:2]  # see https://github.com/obophenotype/cell-ontology/issues/3237
tmp = tmp[-bad]
bad = grep("STATO_0000663", tmp)[1:2]  # see https://github.com/obophenotype/cell-ontology/issues/3237
tmp = tmp[-bad]
tf = tempfile()
writeLines(tmp, tf)
cle = setup_entities2(tf)
ntag = gsub(":", "_", cl3k)
onto_plot2(cle, ntag)
}
