% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting2.R
\name{move2Ds}
\alias{move2Ds}
\title{Displays a spatial proteomics animation}
\usage{
move2Ds(object, pcol, fcol = "markers", n = 25, hl)
}
\arguments{
\item{object}{An \code{linkS4class{MSnSet}} or a
\code{MSnSetList}. In the latter case, only the two first elements
of the list will be used for plotting and the others will be
silently ignored.}

\item{pcol}{If \code{object} is an \code{MSnSet}, a \code{factor}
or the name of a phenotype variable (\code{phenoData} slot)
defining how to split the single \code{MSnSet} into two or more
data sets.  Ignored if \code{object} is a
\code{\link{MSnSetList}}.}

\item{fcol}{Feature meta-data label (fData column name) defining
the groups to be differentiated using different colours. Default
is \code{markers}. Use \code{NULL} to suppress any colouring.}

\item{n}{Number of frames, Default is 25.}

\item{hl}{An optional instance of class
\code{linkS4class{FeaturesOfInterest}} to track features of
interest.}
}
\value{
Used for its side effect of producing a short animation.
}
\description{
Given two \code{MSnSet} instances of one \code{MSnSetList} with at
least two items, this function produces an animation that shows
the transition from the first data to the second.
}
\examples{
library("pRolocdata")
data(dunkley2006)

## Create a relevant MSnSetList using the dunkley2006 data
xx <- split(dunkley2006, "replicate")
xx1 <- xx[[1]]
xx2 <- xx[[2]]
fData(xx1)$markers[374] <- "Golgi"
fData(xx2)$markers[412] <- "unknown"
xx@x[[1]] <- xx1
xx@x[[2]] <- xx2

## The features we want to track
foi <- FeaturesOfInterest(description = "test",
                          fnames = featureNames(xx[[1]])[c(374, 412)])

## (1) visualise each experiment separately
par(mfrow = c(2, 1))
plot2D(xx[[1]], main = "condition A")
highlightOnPlot(xx[[1]], foi)
plot2D(xx[[2]], mirrorY = TRUE, main = "condition B")
highlightOnPlot(xx[[2]], foi, args = list(mirrorY = TRUE))

## (2) plot both data on the same plot
par(mfrow = c(1, 1))
tmp <- plot2Ds(xx) 
highlightOnPlot(data1(tmp), foi, lwd = 2)
highlightOnPlot(data2(tmp), foi, pch = 5, lwd = 2)

## (3) create an animation
move2Ds(xx, pcol = "replicate")
move2Ds(xx, pcol = "replicate", hl = foi)
}
\seealso{
\code{\link{plot2Ds}} to a single figure with the two
datasets.
}
\author{
Laurent Gatto
}
