% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{vec_phantom}
\alias{vec_phantom}
\alias{plyxp-printing}
\alias{plyxp_pillar_format}
\alias{show_tidy}
\alias{use_show_tidy}
\alias{use_show_default}
\title{Printing within tibble with S4 objects}
\usage{
vec_phantom(x)

plyxp_pillar_format(x, ...)

show_tidy(x, ...)

use_show_tidy()

use_show_default()
}
\arguments{
\item{x}{The S4 object}

\item{...}{other arguments passed from \code{\link[pillar:pillar_shaft]{pillar_shaft}}}
}
\value{
\code{plyxp_pillar_format} -> formatted version of your S4 vector
\code{vec_phantom} -> integer vector with arbitrary object in \code{phatomData} attribute.
}
\description{
\code{plyxp} uses \link[pillar:pillar-package]{pillar} for its printing.
If you want to change how your S4 object is printed within
\code{plyxp}'s print method, consider writing a method for
this function.

To print S4 objects in a tibble, \code{plyxp} hacks a custom
integer vector built from \code{\link[vctrs:new_vctr]{vctrs}} where
the S4 object lives in an attribute named "phantomData".
You can create your own S4 phantom vector with \code{vec_phantom()}.
This function is not used outside of printing for \code{plyxp}

The default method for formatting a \code{vec_phantom()} is to call
\code{\link[S4Vectors:show-utils]{showAsCell()}}.
}
\section{tidy printing}{


By default, \code{plyxp} will not affect the show method for
\code{SummarizedExperiment} objects. The \code{PlySummarizedExperiment} object will
always use the tibble abstraction method. If you want to use tibble
abstraction, you may use \code{use_show_tidy()} to enable or \code{use_show_default()} #' to disable this feature. These functions are called for their side effects, #' modifying the global option
"show_SummarizedExperiment_as_tibble_abstraction".

To show an object as the tibble abstraction regardless of the set option,
use the S3 generic \code{show_tidy(...)}.
}

\examples{

if (require("IRanges")) {
  ilist <- IRanges::IntegerList(list(c(1L, 2L, 3L), c(5L, 6L)))
  phantom <- vec_phantom(ilist)
  pillar::pillar_shaft(phantom)

  plyxp_pillar_format.CompressedIntegerList <- function(x) {
    sprintf("Int: [\%i]", lengths(x))
  }
  print(pillar::pillar_shaft(phantom))
  rm(plyxp_pillar_format.CompressedIntegerList)
}

# default printing for PlySummarizedExperiment object
se_simple
# default printing for SummarizedExperiment object
se <- se(se_simple)
se
# use `plyxp` tibble abstraction
use_show_tidy()
se
# restore default print
use_show_default()
se
# explicitly using tibble abstraction
show_tidy(se)

}
