% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPartitionMetrics.R
\name{getPartitionMetrics}
\alias{getPartitionMetrics}
\title{Compute partition-based metrics}
\usage{
getPartitionMetrics(true, pred, metrics = NULL, level = "class", ...)
}
\arguments{
\item{true}{A vector containing the labels of the true classes. Must be a
vector of characters, integers, numerics, or a factor, but not a list.}

\item{pred}{A vector containing the labels of the predicted clusters. Must
be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{metrics}{The metrics to compute. If omitted, main metrics will be
computed. See details.}

\item{level}{The level to calculate the metrics. Options include "element",
\code{"class"} and \code{"dataset"}.}

\item{...}{Optional arguments for MI, VI, or VM. See \code{\link[clevr:mutual_info]{clevr::mutual_info()}},
\code{\link[clevr:variation_info]{clevr::variation_info()}}
and \code{\link[clevr:v_measure]{clevr::v_measure()}} for more details.}
}
\value{
A data.frame of metrics.
}
\description{
Computes a selection of external evaluation metrics for partition.
}
\details{
The allowed values for \code{metrics} depend on the value of \code{level}:
\itemize{
\item If \code{level = "element"}, the allowed \code{metrics} are:
\itemize{
\item \code{"SPC"}: Spot-wise Pair Concordance.
\item \code{"ASPC"}: Adjusted Spot-wise Pair Concordance.
}
\item If \code{level = "class"}, the allowed \code{metrics} are: \code{"WC"},\code{"WH"},\code{"AWC"},
\code{"AWH"},\code{"FM"} (see below for details).
\item If \code{level = "dataset"}, the allowed \code{metrics} are:
\itemize{
\item \code{"RI"}: Rand Index
\item \code{"WC"}: Wallace Completeness
\item \code{"WH"}: Wallace Homogeneity
\item \code{"ARI"}: Adjusted Rand Index
\item \code{"AWC"}: Adjusted Wallace Completeness
\item \code{"AWH"}: Adjusted Wallace Homogeneity
\item \code{"NCR"}: Normalized class size Rand index
\item \code{"MI"}: Mutual Information
\item \code{"AMI"}: Adjusted Mutual Information
\item \code{"VI"}: Variation of Information
\item \code{"EH"}: (Entropy-based) Homogeneity
\item \code{"EC"}: (Entropy-based) Completeness
\item \code{"VM"}: V-measure
\item \code{"FM"}: F-measure/weighted average F1 score
\item \code{"VDM"}: Van Dongen Measure
\item \code{"MHM"}: Meila-Heckerman Measure
\item \code{"MMM"}: Maximum-Match Measure
\item \code{"Mirkin"}: Mirkin Metric
\item \code{"Accuracy"}: Set Matching Accuracy
}
}
}
\examples{
true <- rep(LETTERS[seq_len(3)], each=10)
pred <- c(rep("A", 8), rep("B", 9), rep("C", 3), rep("D", 10))
getPartitionMetrics(true, pred, level="class")
getPartitionMetrics(true, pred, level="dataset")
}
