% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_counts.R
\name{read_counts}
\alias{read_counts}
\title{Read a counts file}
\usage{
read_counts(counts_file, samples = NULL)
}
\arguments{
\item{counts_file}{A \code{character(1)} with the local path to a \code{recount3}
counts file.}

\item{samples}{A \code{character()} with \code{external_id} sample IDs to read in. When
\code{NULL} (default), all samples will be read in. This argument is used by
\code{create_rse_manual()}.}
}
\value{
A \code{data.frame()} with sample IDs as the column names.
}
\description{
This function reads in a \code{recount3} gene or gexon counts file into R. You can
first locate the file using \code{locate_url()} then download it to your
computer using \code{file_retrieve()}.
}
\examples{

## Download the gene counts file for project SRP009615
url_SRP009615_gene <- locate_url(
    "SRP009615",
    "data_sources/sra",
    type = "gene"
)
local_SRP009615_gene <- file_retrieve(url = url_SRP009615_gene)

## Read the gene counts, take about 3 seconds
system.time(SRP009615_gene_counts <- read_counts(local_SRP009615_gene))
dim(SRP009615_gene_counts)

## Explore the top left corner
SRP009615_gene_counts[seq_len(6), seq_len(6)]

## Explore the first 6 samples.
summary(SRP009615_gene_counts[, seq_len(6)])

## Note that the count units are in
## base-pair coverage counts just like in the recount2 project.
## See https://doi.org/10.12688/f1000research.12223.1 for more details
## about this type of counts.
## They can be converted to reads per 40 million reads, RPKM and other
## counts. This is more easily done once assembled into a
## RangedSummarizedExperiment object.

## Locate and retrieve an exon counts file
local_SRP009615_exon <- file_retrieve(
    locate_url(
        "SRP009615",
        "data_sources/sra",
        type = "exon"
    )
)
local_SRP009615_exon

## Read the exon counts, takes about 50-60 seconds
system.time(
    SRP009615_exon_counts <- read_counts(
        local_SRP009615_exon
    )
)
dim(SRP009615_exon_counts)
pryr::object_size(SRP009615_exon_counts)

## Explore the top left corner
SRP009615_exon_counts[seq_len(6), seq_len(6)]

## Explore the first 6 samples.
summary(SRP009615_exon_counts[, seq_len(6)])
}
\references{
\url{https://doi.org/10.12688/f1000research.12223.1} for details on the
base-pair coverage counts used in recount2 and recount3.
}
\seealso{
Other internal functions for accessing the recount3 data: 
\code{\link{annotation_ext}()},
\code{\link{create_rse_manual}()},
\code{\link{file_retrieve}()},
\code{\link{locate_url}()},
\code{\link{locate_url_ann}()},
\code{\link{project_homes}()},
\code{\link{read_metadata}()}
}
\concept{internal functions for accessing the recount3 data}
