% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_alignToRefs.R
\name{alignToRefs}
\alias{alignToRefs}
\title{Align user sequences to packaged rhinovirus prototype references}
\usage{
alignToRefs(
  seqData,
  method = c("ClustalW", "ClustalOmega", "Muscle"),
  trimToRef = TRUE,
  refName = "JN855971.1_A107",
  ...
)
}
\arguments{
\item{seqData}{A \code{Biostrings::DNAStringSet} containing the user
sequences to be aligned.}

\item{method}{Character; one of \code{"ClustalW"}, \code{"ClustalOmega"},
or \code{"Muscle"}. Passed to \code{msa::msa}.}

\item{trimToRef}{\code{logical(1)}. If \code{TRUE} (default), crop the aligned
\code{DNAStringSet} to the span of the reference sequence (useful when user
sequences extend beyond the targeted VP4/2 region).}

\item{refName}{\code{character(1)}. Name of the reference sequence that
defines the trimming span when \code{trimToRef = TRUE}. Defaults to
\code{"JN855971.1_A107"} (a VP4/2 prototype used as a convenient anchor;
it has no special biological significance). Provide a different accession
to change the trimming anchor.}

\item{...}{Additional arguments forwarded to \code{msa::msa}
(e.g., gap penalties).}
}
\value{
A \code{Biostrings::DNAStringSet} of aligned sequences (user + prototypes),
  all with identical width; if \code{trimToRef = TRUE}, cropped to the chosen
  reference’s non-gap span.
}
\description{
Combines imported sequences with the prototype rhinovirus references shipped 
in \pkg{rhinotypeR}. Performs a multiple sequence alignment using ClustalW, 
ClustalOmega, or MUSCLE. The aligned result is returned as a 
\code{DNAStringSet} with equal-width sequences, suitable for downstream 
distance calculations (e.g., \code{\link{pairwiseDistances}}). 
If \code{trimToRef = TRUE}, the final alignment is cropped to the 
non-gap span of a chosen reference sequence.
}
\details{
Packaged prototypes are loaded from
\code{system.file("extdata","prototypes.fasta", package = "rhinotypeR")}.
User sequences are appended and jointly aligned with \code{msa::msa}. The
returned \code{DNAStringSet} has equal width. When \code{trimToRef = TRUE},
the alignment is cropped to the range covered by non-gap positions in
\code{refName}; internal gaps within that span are preserved. For global
removal of gap-containing columns across all sequences, see
\code{deleteMissingDataSites()}.

If you prefer to align/curate outside R, use
\code{\link{getPrototypeSeqs}} to copy the prototype references to disk and
import your curated alignment later.
}
\section{Notes / Caveats}{

\itemize{
  \item \strong{Method selection:} \code{msa::msa} expects a single method
        string; this wrapper enforces that with \code{match.arg()}.
  \item \strong{Homology:} Ensure sequences are homologous and from the same
        genomic region; MSA quality degrades on mixed loci.
  \item \strong{Result class:} The function returns a \code{DNAStringSet}
        (not a \code{DNAMultipleAlignment}).
}
}

\examples{
seqs_path <- system.file("extdata", "test.fasta", package = "rhinotypeR")
seqs <- Biostrings::readDNAStringSet(seqs_path)

aln_trim <- alignToRefs(seqs, method = "ClustalW", trimToRef = TRUE)

# Keep full joint alignment (no trimming)
aln_full <- alignToRefs(seqs, method = "ClustalW", trimToRef = FALSE)

# Use a different prototype as trimming anchor
# aln_sel <- alignToRefs(seqs, method = "Muscle", trimToRef = TRUE,
#                        refName = "AF343653.1_B27")

}
\seealso{
\code{\link{getPrototypeSeqs}}, \code{\link{pairwiseDistances}},
  \code{\link{assignTypes}}
}
