% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_networks.R
\name{infer_networks}
\alias{infer_networks}
\title{Infer Gene Regulatory Networks from Expression Matrices}
\usage{
infer_networks(
  count_matrices_list,
  method = c("GENIE3", "GRNBoost2", "ZILGM", "JRF", "PCzinb"),
  adjm = NULL,
  nCores = 1,
  grnboost_modules = NULL,
  genie3_params = list(),
  grnboost2_params = list(),
  zilgm_params = list(),
  jrf_params = list(),
  pczinb_params = list(),
  verbose = FALSE
)
}
\arguments{
\item{count_matrices_list}{A \linkS4class{MultiAssayExperiment} object
containing expression data from multiple experiments or conditions.}

\item{method}{Character string. Inference method to use. One of:
\code{"GENIE3"}, \code{"GRNBoost2"}, \code{"ZILGM"},
\code{"JRF"}, or \code{"PCzinb"}.}

\item{adjm}{Optional. Reference adjacency matrix for matching dimensions
when using \code{"ZILGM"} or \code{"PCzinb"}.}

\item{nCores}{Integer. Number of CPU cores to use for
parallelization. Default: 1.}

\item{grnboost_modules}{Python modules required for \code{GRNBoost2}
(created via \pkg{reticulate}).}

\item{genie3_params}{List of parameters for GENIE3 method:
\itemize{
\item \code{regulators}: Vector of regulator gene names (default: all)
\item \code{targets}: Vector of target gene names (default: all genes)
\item \code{treeMethod}: "RF" or "ET" (default: "RF")
\item \code{K}: Number of candidate regulators (default: "sqrt")
\item \code{nTrees}: Number of trees per ensemble (default: 1000)
\item \code{seed}: Random seed for reproducibility (default: NULL)
}}

\item{grnboost2_params}{List of parameters for GRNBoost2 method:
\itemize{
\item \code{tf_names}: Vector of transcription factor names (default:all)
\item \code{gene_names}: Vector of target gene names (default: all)
\item \code{client_or_address}: Dask client or address (default: NULL)
\item \code{seed}: Random seed for reproducibility (default: NULL)
}}

\item{zilgm_params}{List of parameters for ZILGM method:
\itemize{
\item \code{lambda}: Regularization parameter (default: 0.1)
\item \code{alpha}: Elastic net mixing parameter (default: 1)
\item \code{max_iter}: Maximum iterations (default: 100)
\item \code{tol}: Convergence tolerance (default: 1e-4)
}}

\item{jrf_params}{List of parameters for JRF method:
\itemize{
\item \code{ntree}: Number of trees (default: 1000)
\item \code{mtry}: Number of variables to sample at each split
(default: sqrt(p))
}}

\item{pczinb_params}{List of parameters for PCzinb method:
\itemize{
\item \code{gamma}: Regularization parameter (default: 0.1)
\item \code{beta}: Beta parameter (default: 0.1)
\item \code{max_iter}: Maximum iterations (default: 100)
\item \code{tol}: Convergence tolerance (default: 1e-4)
}}

\item{verbose}{Logical. If TRUE, display messages. Default: FALSE.}
}
\value{
A list of inferred networks:
\itemize{
\item For \code{"GENIE3"}, \code{"GRNBoost2"}, \code{"ZILGM"},
and \code{"PCzinb"}, a list of inferred network objects (edge
lists or adjacency matrices).
\item For \code{"JRF"}, a list of data frames with inferred edge
lists for each condition or dataset.
}
}
\description{
Infers weighted gene regulatory networks (GRNs) from one or more
expression matrices using different inference methods:
\code{"GENIE3"}, \code{"GRNBoost2"}, \code{"ZILGM"},
\code{"JRF"}, or \code{"PCzinb"}.
}
\details{
Each expression matrix is preprocessed automatically depending
on its object type (\code{Seurat}, \code{SingleCellExperiment}, or
plain matrix).

Parallelization behavior:
\itemize{
\item \strong{GENIE3}: No external parallelization; internal
\code{nCores} parameter controls computation.
\item \strong{ZILGM}: Uses \code{nCores} parameter for internal
parallelization.
\item \strong{GRNBoost2} and \strong{PCzinb}: Parallelized across
matrices using \pkg{BiocParallel}.
\item \strong{JRF}: Joint modeling of all matrices together using
optimized C implementation.
}

Methods are based on:
\itemize{
\item \strong{GENIE3}: Random Forest-based inference (Huynh-Thu et
al., 2010).
\item \strong{GRNBoost2}: Gradient boosting trees using arboreto
(Moerman et al., 2019).
\item \strong{ZILGM}: Zero-Inflated Graphical Models for scRNA-seq
(Zhang et al., 2021).
\item \strong{JRF}: Joint Random Forests across multiple conditions
(Petralia et al., 2015).
\item \strong{PCzinb}: Pairwise correlation under ZINB models
(Nguyen et al., 2023).
}
}
\examples{
data("toy_counts")

# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)
head(networks[[1]])
}
