% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getContigDoublets.R
\name{getContigDoublets}
\alias{getContigDoublets}
\title{Get Contig Doublets}
\usage{
getContigDoublets(tcrOutput, bcrOutput)
}
\arguments{
\item{tcrOutput}{Output of \code{\link[=combineTCR]{combineTCR()}}. A list of data.frames containing
TCR contig information, each dataframe must have a \code{barcode} column.}

\item{bcrOutput}{Output of \code{\link[=combineBCR]{combineBCR()}}. A list of data.frames containing
BCR contig information, each dataframe must have a \code{barcode} column.}
}
\value{
A dataframe of barcodes that exist in both the TCR and BCR data, with
columns from both sets of data. There will be an additional column
\code{contigType} of type factor with levels 'TCR' and 'BCR' indicating the
origin of the contig - this will be the new first column.

If there are no doublets, the returned
data.frame will have the same colnames but no rows.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function identifies potential doublets by finding common barcodes
between TCR and BCR outputs. It extracts unique barcodes from each list
of dataframes, finds the intersection of the barcodes, and joins the
resulting data.
}
