% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{addCovCor}
\alias{addCovCor}
\title{Add correlation of anchor signals to pairs of close genomic regions.}
\usage{
addCovCor(
  gi,
  datacol = "chip",
  colname = "cor_chip",
  maxDist = NULL,
  use = "everything",
  method = "pearson"
)
}
\arguments{
\item{gi}{A sorted \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} object.}

\item{datacol}{a string matching an annotation column in \code{regions(gi)}.
This column is assumed to hold the same number of values for each
interaction as a \code{NumericList}.}

\item{colname}{A string that is used as columnname for the new column in
\code{gi}.}

\item{maxDist}{maximal distance of pairs in bp as numeric. If maxDist=NULL,
the maximal distance is computed from input interactions gi by
\code{max(pairdist(gi))}.}

\item{use}{an optional character string giving a method for computing
covariances in the presence of missing values. See \code{\link[stats]{cor}}
for more details.}

\item{method}{a character string indicating which correlation coefficient (or
covariance) is to be computed. One of "pearson" (default), "kendall", or
"spearman": can be abbreviated. See \code{\link[stats]{cor}} for more
details.}
}
\value{
A \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} similar to \code{gi}
 just with an additional column added.
}
\description{
This function adds a vector with correlation values for each input
interaction. Only works for input interaction within the given \code{maxDist}
distance. Note, this function does not work on windows because reading of
bigWig files is currently not supported on windows.
}
\examples{
if (.Platform$OS.type != "windows") {

  # use internal motif data on chromosome 22
  motifGR <- sevenC::motif.hg19.CTCF.chr22

  # use example bigWig file
 exampleBigWig <- system.file("extdata",
     "GM12878_Stat1.chr22_1-30000000.bigWig", package = "sevenC")

  # add coverage from bigWig file
  motifGR <- addCovToGR(motifGR, exampleBigWig)

  # get all pairs within 1Mb
  gi <- getCisPairs(motifGR, 1e5)

  # compute correaltion of coverge for each pair
  gi <- addCovCor(gi)

  # addCovCor adds a new metadata column:
  mcols(gi)

}
}
