% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructShapePPP.R
\name{reconstructShapeDensity}
\alias{reconstructShapeDensity}
\title{Reconstruct polygon from point pattern density}
\usage{
reconstructShapeDensity(ppp, markSelect = NULL, bndw = NULL, thres = NULL, dim)
}
\arguments{
\item{ppp}{point pattern object of class \code{ppp}}

\item{markSelect}{character; name of mark that is to be selected for the
reconstruction}

\item{bndw}{bandwidth of kernel density estimator}

\item{thres}{intensity threshold for the reconstruction}

\item{dim}{numeric; x dimension of the final reconstruction.}
}
\value{
sf object of class \code{POLYGON}
}
\description{
This function estimates the density of a spatial point pattern (\code{ppp}),
thresholds the density to create a binary image, and then converts it
to a valid \code{sf} object (polygons).
}
\examples{
data("sostaSPE")
ppp <- SPE2ppp(sostaSPE, marks = "cellType", imageCol = "imageName", imageId = "image1")
thres <- findIntensityThreshold(ppp, markSelect = "A", dim = 500)
struct <- reconstructShapeDensity(ppp, markSelect = "A", thres = thres, dim = 500)
plot(struct)
}
