% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellLevelMetrics.R
\name{assingCellsToStructures}
\alias{assingCellsToStructures}
\title{Function to assign points / coordinates to structures}
\usage{
assingCellsToStructures(
  spe,
  allStructs,
  imageCol,
  uniqueId = "structID",
  nCores = 1
)
}
\arguments{
\item{spe}{SpatialExperiment; An object of class \code{SpatialExperiment} containing spatial point data. Must contain \code{colnames} for correct assignment.}

\item{allStructs}{sf; A simple feature collection (sf object) representing spatial structures. Must contain a column which contains a unique identifier for each structure. Default = \code{structID}.}

\item{imageCol}{character; The column name in \code{spe} and \code{allStructs} that identifies the corresponding image.}

\item{uniqueId}{character; The column name in the simple feature collection for which to compute the assignment.}

\item{nCores}{integer; The number of cores to use for parallel processing (default is 1).}
}
\value{
A named list with structure assignments for each spatial point in \code{spe}. Points that do not overlap with any structure are assigned \code{NA}. Names correspond to \code{colnames} of the \code{SpatialExperiment} input object.
}
\description{
This function assigns each spatial coordinate in a \code{SpatialExperiment} object (\code{spe}) to the first intersecting structure from a given set of spatial structures.
}
\examples{
library("SpatialExperiment")
data("sostaSPE")
allStructs <- reconstructShapeDensitySPE(sostaSPE,
    marks = "cellType", imageCol = "imageName",
    markSelect = "A", bndw = 3.5, thres = 0.045
)
# The function `assingCellsToStructures` needs colnames so we create them here
colnames(sostaSPE) <- paste0("cell_", c(1:dim(sostaSPE)[2]))

res <- assingCellsToStructures(
    spe = sostaSPE, allStructs = allStructs, imageCol = "imageName"
)
# Assign the structure assignment in the order of the columns in the `SpatialExperiment` object
colData(sostaSPE)$structAssign <- res[colnames(sostaSPE)]

if (require("ggplot2")) {
    cbind(
        colData(sostaSPE[, sostaSPE[["imageName"]] == "image1"]),
        spatialCoords(sostaSPE[, sostaSPE[["imageName"]] == "image1"])
    ) |>
        as.data.frame() |>
        ggplot(aes(x = x, y = y, color = structAssign)) +
        geom_point(size = 0.25) +
        coord_equal()
}
}
