% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Run_ST.R
\name{Run_ST}
\alias{Run_ST}
\title{Pre-processing function for sequencing-based spatial transcriptomics}
\usage{
Run_ST(config, show.config = TRUE)
}
\arguments{
\item{config}{Path to the YAML configuration file.}

\item{show.config}{Logical value indicating whether to print the configuration. Defaults to TRUE.}
}
\value{
None. Outputs are saved to specified directories.
}
\description{
Pre-processing from FASTQ files to gene count matrix and extract spatial location information,
processing multiple sample is done via parallel computing. NB: for multiple samples, 'species' and 'technology_version' should be the same.
This function processes sequencing-based spatial transcriptomics data using various steps, including BAM to FASTQ conversion, trimming, index building, alignment, and barcode detection.
For Slideseq technology, the input should be BAM file and for all other technologies the input should be FASTQ file.
}
\examples{
data_path <- system.file("extdata", package = "stPipe")
output_directory <- file.path(tempdir(), "stPipe_output")
config_list <- list(
data_directory = data_path,          
output_directory = output_directory, 
technology_version = "Visium_probe_v1",       
species = "mouse",                   
scpipe_nthreads = 4,                
max_reads = 100000,                  
min_count = 10,                      
number_of_locations = 100,          
bs1= -1,     
bl1= 0,     
bs2= 0,      
bl2= 16,     
us= 16,      
ul= 12,      
ll= 0      
)
config_file <- tempfile(fileext = ".yml")
yaml::write_yaml(config_list, config_file)
Run_ST(
  config = config_file, 
  show.config = FALSE
)
}
