% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{generate_iupac_by_matrix}
\alias{generate_iupac_by_matrix}
\title{Generates IUPAC code for motif matrix}
\usage{
generate_iupac_by_matrix(matrix, threshold = 0.215, code = NULL)
}
\arguments{
\item{matrix}{the position probability matrix of an RNA-binding protein}

\item{threshold}{the threshold probability (nucleotides with lower
probabilities are ignored)}

\item{code}{if IUPAC code table has already been initialized by
\code{\link{init_iupac_lookup_table}}, it can be specified here}
}
\value{
the IUPAC string of the binding site
}
\description{
Generates a compact logo of a motif based on IUPAC codes given by a
position weight matrix
}
\details{
IUPAC RNA nucleotide code:
\tabular{rl}{
  \code{A} \tab Adenine\cr
  \code{C} \tab Cytosine\cr
  \code{G} \tab Guanine\cr
  \code{U} \tab Uracil\cr
  \code{R} \tab A or G\cr
  \code{Y} \tab C or U\cr
  \code{S} \tab G or C\cr
  \code{W} \tab A or U\cr
  \code{K} \tab G or U\cr
  \code{M} \tab A or C\cr
  \code{B} \tab C or G or U\cr
  \code{D} \tab A or G or U\cr
  \code{H} \tab A or C or U\cr
  \code{V} \tab A or C or G\cr
  \code{N} \tab any base
}
}
\examples{
generate_iupac_by_matrix(get_motif_matrix(get_motif_by_id("M178_0.6")[[1]]))
}
\references{
\url{http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html}
}
\seealso{
Other motif functions: 
\code{\link{generate_iupac_by_kmers}()},
\code{\link{generate_kmers_from_iupac}()},
\code{\link{get_motif_by_id}()},
\code{\link{get_motif_by_rbp}()},
\code{\link{get_motifs}()},
\code{\link{get_motifs_meta_info}()},
\code{\link{get_ppm}()},
\code{\link{init_iupac_lookup_table}()},
\code{\link{set_motifs}()}
}
\concept{motif functions}
