% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{exportFASTA}
\alias{exportFASTA}
\title{Export Transcriptome as FASTA}
\usage{
exportFASTA(txdb, genome, file, ...)
}
\arguments{
\item{txdb}{a \code{TxDb} object representing a transcriptome annotation}

\item{genome}{a \code{BSgenome} object from which to extract sequences}

\item{file}{a string for output FASTA file. File names ending in "\strong{.gz}"
will automatically use gzip compression.}

\item{...}{additional arguments to pass through to
\code{\link[Biostrings]{writeXStringSet}}}
}
\value{
The \code{txdb} argument is invisibly returned.
}
\description{
Export Transcriptome as FASTA
}
\examples{
library(TxDb.Scerevisiae.UCSC.sacCer3.sgdGene)
library(BSgenome.Scerevisiae.UCSC.sacCer3)

## load annotation and genome
txdb <- TxDb.Scerevisiae.UCSC.sacCer3.sgdGene
sacCer3 <- BSgenome.Scerevisiae.UCSC.sacCer3

## restrict to 'chrI' transcripts (makes for briefer example runtime)
seqlevels(txdb) <- c("chrI")

## last 500 nts per tx
txdb_w500 <- truncateTxome(txdb)

## export uncompressed
outfile <- tempfile("sacCer3.sgdGene.w500", fileext=".fa")
exportFASTA(txdb_w500, sacCer3, outfile)

## export compressed
outfile <- tempfile("sacCer3.sgdGene.w500", fileext=".fa.gz")
exportFASTA(txdb_w500, sacCer3, outfile)

}
