% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{exportMergeTable}
\alias{exportMergeTable}
\title{Export Merge Table for Transcriptome}
\usage{
exportMergeTable(txdb, file, minDistance = 200L)
}
\arguments{
\item{txdb}{a \code{TxDb} object representing a transcriptome annotation}

\item{file}{a string or \code{\link{connection}} to output TSV file.
Automatically recognizes strings ending with "\strong{.gz}" for zipped output.}

\item{minDistance}{the minimum separation to regard overlapping transcripts
as unique.}
}
\value{
The \code{txdb} argument is invisibly returned.
}
\description{
Export Merge Table for Transcriptome
}
\examples{
library(TxDb.Scerevisiae.UCSC.sacCer3.sgdGene)

## load annotation
txdb <- TxDb.Scerevisiae.UCSC.sacCer3.sgdGene

## restrict to 'chrI' transcripts (makes for briefer example runtime)
seqlevels(txdb) <- c("chrI")

## last 500 nts per tx
txdb_w500 <- truncateTxome(txdb)

## export plain format
outfile <- tempfile("sacCer3.sgdGene.w500", fileext=".tsv")
exportMergeTable(txdb_w500, outfile)

## export compressed format
outfile <- tempfile("sacCer3.sgdGene.w500", fileext=".tsv.gz")
exportMergeTable(txdb_w500, outfile)

}
