% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{generateMergeTable}
\alias{generateMergeTable}
\alias{generateMergeTable,TxDb-method}
\title{Generate Merge Table}
\usage{
generateMergeTable(txdb, minDistance = 200)

\S4method{generateMergeTable}{TxDb}(txdb, minDistance = 200L)
}
\arguments{
\item{txdb}{an object representing a transcriptome}

\item{minDistance}{the minimum separation to regard overlapping transcripts
as unique}
}
\value{
a \code{data.frame} with three columns
- \code{tx_in} the input transcript
- \code{tx_out} the transcript merged into
- \code{gene_out} the gene merged into

a \code{data.frame} with three columns
- \code{tx_in} the input transcript
- \code{tx_out} the transcript merged into
- \code{gene_out} the gene merged into
}
\description{
Generate Merge Table
}
\examples{
library(TxDb.Scerevisiae.UCSC.sacCer3.sgdGene)

## load annotation
txdb <- TxDb.Scerevisiae.UCSC.sacCer3.sgdGene

## restrict to 'chrI' transcripts
seqlevels(txdb) <- c("chrI")

## last 500 nts per tx
txdb_w500 <- truncateTxome(txdb)
txdb_w500

## last 100 nts per tx
txdb_w100 <- truncateTxome(txdb, maxTxLength=100)
txdb_w100

}
