% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XcmsExperiment-plotting.R
\name{plotAdjustedRtime}
\alias{plotAdjustedRtime}
\title{Visualization of Alignment Results}
\usage{
plotAdjustedRtime(
  object,
  col = "#00000080",
  lty = 1,
  lwd = 1,
  type = "l",
  adjustedRtime = TRUE,
  xlab = ifelse(adjustedRtime, yes = expression(rt[adj]), no = expression(rt[raw])),
  ylab = expression(rt[adj] - rt[raw]),
  peakGroupsCol = "#00000060",
  peakGroupsPch = 16,
  peakGroupsLty = 3,
  ylim,
  ...
)
}
\arguments{
\item{object}{A \code{\link[=XcmsExperiment]{XcmsExperiment()}} or \code{\link[=XCMSnExp]{XCMSnExp()}} object with the alignment
results.}

\item{col}{color(s) for the individual lines. Has to be of length 1 or equal
to the number of samples.}

\item{lty}{line type for the lines of the individual samples.}

\item{lwd}{line width for the lines of the individual samples.}

\item{type}{plot \emph{type} (see \code{\link[=par]{par()}} for options; defaults to \code{type = "l"}).}

\item{adjustedRtime}{\code{logical(1)} whether adjusted or raw retention times
should be shown on the x-axis.}

\item{xlab}{the label for the x-axis.}

\item{ylab}{the label for the y-axis.}

\item{peakGroupsCol}{color to be used for the peak groups (only if
alignment was performed using the \emph{peak groups} method.}

\item{peakGroupsPch}{point character (\code{pch}) to be used for the peak
groups (only if alignment was performed using the \emph{peak groups}
method.}

\item{peakGroupsLty}{line type (\code{lty}) to be used to connect points for
each peak groups (only if alignment was performed using the
\emph{peak groups} method.}

\item{ylim}{optional \code{numeric(2)} with the upper and lower limits on
the y-axis.b}

\item{...}{Additional arguments to be passed down to the \code{plot}
function.}
}
\description{
The \code{plotAdjustedRtime} function plots the difference between the adjusted
and \emph{raw} retention times on the y-axis against the raw retention times on
the x-axis. Each line represents the results for one sample (file).
If alignment was performed using the \emph{peak groups} method (see
\code{\link[=adjustRtime]{adjustRtime()}} for more infromation) also the peak groups used in the
alignment are visualized.
}
\examples{

## Load a test data set with detected peaks
faahko_sub <- loadXcmsData("faahko_sub2")

## Disable parallel processing for this example
register(SerialParam())

## Performing the peak grouping using the "peak density" method.
p <- PeakDensityParam(sampleGroups = c(1, 1, 1))
res <- groupChromPeaks(faahko_sub, param = p)

## Perform the retention time adjustment using peak groups found in both
## files.
fgp <- PeakGroupsParam(minFraction = 1)
res <- adjustRtime(res, param = fgp)

## Visualize the impact of the alignment.
plotAdjustedRtime(res, adjusted = FALSE)
grid()
}
\author{
Johannes Rainer
}
