\name{org.Sc.sgdCHR}
\alias{org.Sc.sgdCHR}
\title{Map ORF IDs to Chromosomes}
\description{
 org.Sc.sgdCHR is an R object that provides mappings between ORF
 identifiers and the chromosome that contains the gene of interest. 
}
\details{
  Each ORF identifier maps to a vector of a chromosome. 
  
  Mappings were based on data provided by: Yeast Genome  
  http://sgd-archive.yeastgenome.org  
  With a date stamp from the source of: 2025-Sep23
}

\seealso{
  \itemize{
    \item \code{\link[AnnotationDbi]{AnnotationDb-class}} for use of
          the \code{select()} interface.
  }
}

\examples{
## select() interface:
## Objects in this package can be accessed using the select() interface
## from the AnnotationDbi package. See ?select for details.

## Bimap interface:
x <- org.Sc.sgdCHR
# Get the ORF identifiers that are mapped to a chromosome
mapped_genes <- mappedkeys(x)
# Convert to a list
xx <- as.list(x[mapped_genes])
if(length(xx) > 0) {
  # Get the CHR for the first five genes
  xx[1:5]
  # Get the first one
  xx[[1]]
}
}
\keyword{datasets}

