% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_lister.R
\name{file_lister}
\alias{file_lister}
\title{NMR file lister}
\usage{
file_lister(dataset_path_nmr, glob)
}
\arguments{
\item{dataset_path_nmr}{A character vector of the path where samples are.}

\item{glob}{A wildcard or globbing pattern common for the samples to be read,
for example ending with *0 (spectra acquired by a NOESY sequence often end
by 0: 10, 20, 30...) or *s (for example, samples from the tutorial in this
package) passed on to \code{grep()} to filter paths.}
}
\value{
lists of samples from the chosen folder
}
\description{
The function lists samples from the chosen folder required to import and
create a \link{nmr_dataset_1D} object. The function is based on the \code{\link[fs:dir_ls]{fs::dir_ls()}}
function.
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
lists_of_samples <- file_lister(dir_to_demo_dataset, "*0")

}
