% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_1D.R
\name{format.nmr_dataset_1D}
\alias{format.nmr_dataset_1D}
\title{format for nmr_dataset_1D}
\usage{
\method{format}{nmr_dataset_1D}(x, ...)
}
\arguments{
\item{x}{an \link{nmr_dataset_1D} object}

\item{...}{for future use}
}
\value{
format for nmr_dataset_1D
}
\description{
format for nmr_dataset_1D
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
format(dataset_1D)
}
\seealso{
Other class helper functions: 
\code{\link{format.nmr_dataset}()},
\code{\link{format.nmr_dataset_peak_table}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{is.nmr_dataset_peak_table}()},
\code{\link{new_nmr_dataset}()},
\code{\link{new_nmr_dataset_1D}()},
\code{\link{new_nmr_dataset_peak_table}()},
\code{\link{print.nmr_dataset}()},
\code{\link{print.nmr_dataset_1D}()},
\code{\link{print.nmr_dataset_peak_table}()},
\code{\link{validate_nmr_dataset}()},
\code{\link{validate_nmr_dataset_family}()},
\code{\link{validate_nmr_dataset_peak_table}()}

Other nmr_dataset_1D functions: 
\code{\link{[.nmr_dataset_1D}()},
\code{\link{get_integration_with_metadata}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_ppm_resolution}()},
\code{\link{print.nmr_dataset_1D}()}
}
\concept{class helper functions}
\concept{nmr_dataset_1D functions}
