% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_peak_clustering.R
\name{nmr_peak_clustering}
\alias{nmr_peak_clustering}
\title{Peak clustering}
\usage{
nmr_peak_clustering(
  peak_data,
  peak2peak_dist = NULL,
  num_clusters = NULL,
  max_dist_thresh_ppb = NULL,
  verbose = FALSE
)
}
\arguments{
\item{peak_data}{The peak list}

\item{peak2peak_dist}{The distances obtained with \link{nmr_get_peak_distances}.
If NULL it is computed from \code{peak_data}}

\item{num_clusters}{If you want to fix the number of clusters. Leave \code{NULL} if you want to estimate it}

\item{max_dist_thresh_ppb}{To estimate the number of clusters, we enforce a limit on how far two peaks of the same cluster may be. By default
this threshold will be computed as 3 times the median peak width (gamma), as given in the peak list.}

\item{verbose}{A logical vector to print additional information}
}
\value{
A list including:
\itemize{
\item The \code{peak_data} with an additional "cluster" column
\item cluster: the hierarchical cluster
\item num_clusters: an estimation of the number of clusters
\item num_cluster_estimation: A list with tables and plots to justify the number of cluster estimation
}
}
\description{
Peak clustering
}
\examples{
peak_data <- data.frame(
    NMRExperiment = c("10", "10", "20", "20"),
    peak_id = paste0("Peak", 1:4),
    ppm = c(1, 2, 1.1, 2.2),
    gamma_ppb = 100
)
clustering_result <- nmr_peak_clustering(peak_data)
peak_data <- clustering_result$peak_data
stopifnot("cluster" \%in\% colnames(peak_data))
}
