% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset.R
\name{nmr_read_samples}
\alias{nmr_read_samples}
\alias{nmr_read_samples_dir}
\title{Read NMR samples}
\usage{
nmr_read_samples_dir(
  samples_dir,
  format = "bruker",
  pulse_sequence = NULL,
  metadata_only = FALSE,
  ...
)

nmr_read_samples(
  sample_names,
  format = "bruker",
  pulse_sequence = NULL,
  metadata_only = FALSE,
  ...
)
}
\arguments{
\item{samples_dir}{A directory or directories that contain multiple samples}

\item{format}{Either "bruker" or "jdx"}

\item{pulse_sequence}{If it is set to a pulse sequence
("NOESY", "JRES", "CPMG"...) it will only load
the samples that match that pulse sequence.}

\item{metadata_only}{A logical, to load only metadata (default: \code{FALSE})}

\item{...}{
  Arguments passed on to \code{\link[=read_bruker_pdata]{read_bruker_pdata}}
  \describe{
    \item{\code{pdata_file}}{File name of the binary NMR data to load. Usually "1r".
If \code{NULL}, it is autodetected based on the dimension}
    \item{\code{sample_path}}{A character path of the sample directory}
    \item{\code{pdata_path}}{Path from \code{sample_path} to the preprocessed data}
    \item{\code{all_components}}{If \code{FALSE} load only the real component. Otherwise load the real and imaginary components}
    \item{\code{read_pdata_title}}{If \code{TRUE} also reads metadata from pdata title file.}
  }}

\item{sample_names}{A character vector with file or directory names.}
}
\value{
a \link{nmr_dataset} object
}
\description{
These functions load samples from files and return a \link{nmr_dataset}.
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)

dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
zip_files <- fs::dir_ls(dir_to_demo_dataset, glob = "*.zip")
dataset <- nmr_read_samples(sample_names = zip_files)

}
\seealso{
\code{\link[=read_bruker_pdata]{read_bruker_pdata()}}

Other import/export functions: 
\code{\link{Pipelines}},
\code{\link{files_to_rDolphin}()},
\code{\link{load_and_save_functions}},
\code{\link{nmr_data}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_read_bruker_fid}()},
\code{\link{nmr_zip_bruker_samples}()},
\code{\link{save_files_to_rDolphin}()},
\code{\link{save_profiling_output}()},
\code{\link{to_ChemoSpec}()}
}
\concept{import/export functions}
