% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avworkflow_configuration.R
\name{avworkflow_config-defunct}
\alias{avworkflow_config-defunct}
\alias{avworkflow_configurations}
\alias{avworkflow_namespace}
\alias{avworkflow_name}
\alias{avworkflow}
\alias{avworkflow_configuration_get}
\alias{avworkflow_configuration_inputs}
\alias{avworkflow_configuration_outputs}
\alias{avworkflow_configuration_update}
\alias{avworkflow_configuration_set}
\alias{avworkflow_configuration_template}
\alias{print.avworkflow_configuration}
\title{DEFUNCT - Workflow configuration}
\usage{
avworkflow_namespace(workflow_namespace = NULL)

avworkflow_name(workflow_name = NULL)

avworkflow(workflow = NULL)

avworkflow_configuration_get(
  workflow_namespace = avworkflow_namespace(),
  workflow_name = avworkflow_name(),
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)

avworkflow_configuration_inputs(config)

avworkflow_configuration_outputs(config)

avworkflow_configuration_update(
  config,
  inputs = avworkflow_configuration_inputs(config),
  outputs = avworkflow_configuration_outputs(config)
)

avworkflow_configuration_set(
  config,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  dry = TRUE
)

avworkflow_configuration_template()

\method{print}{avworkflow_configuration}(x, ...)
}
\arguments{
\item{workflow_namespace}{character(1) AnVIL workflow namespace, as
returned by, e.g., the \code{namespace} column of \code{avworkflows()}.}

\item{workflow_name}{character(1) AnVIL workflow name, as returned
by, e.g., the \code{name} column of \code{avworkflows()}.}

\item{workflow}{character(1) representing the combined workflow
namespace and name, as \code{namespace/name}.}

\item{namespace}{character(1) AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{name}{character(1) AnVIL workspace name as returned by, eg.,
\code{avworkspace_name()}.}

\item{config}{a named list describing the full configuration, e.g.,
created from editing the return value of
\code{avworkflow_configuration_set()} or
\code{avworkflow_configuration_template()}.}

\item{inputs}{the new inputs to be updated in the workflow configuration. If
none are specified, the inputs from the original configuration will be
used and no changes will be made.}

\item{outputs}{the new outputs to be updated in the workflow configuration.
If none are specified, the outputs from the original configuration will
be used and no changes will be made.}

\item{dry}{logical(1) when \code{TRUE} (default), report the
consequences but do not perform the action requested. When
\code{FALSE}, perform the action.}

\item{x}{Object of class \code{avworkflow_configuration}.}

\item{...}{additional arguments to \code{print()}; unused.}
}
\value{
\code{avworkflow_namespace()}, and \code{avworkflow_name()} return
\code{character(1)} identifiers. \code{avworkflow()} returns the
character(1) concatenated namespace and name. The value
returned by \code{avworkflow_name()} will be percent-encoded (e.g.,
spaces \code{" "} replaced by \code{"\%20"}).

\code{avworkflow_configuration_get()} returns a list structure
describing the configuration. See
\code{avworkflow_configuration_template()} for the structure of a
typical workflow.

\code{avworkflow_configuration_inputs()} returns a data.frame
providing a template for the configuration inputs, with the
following columns:
\itemize{
\item inputType
\item name
\item optional
\item attribute
}

The only column of interest to the user is the \code{attribute}
column, this is the column that should be changed for
customization.

\code{avworkflow_configuration_outputs()} returns a data.frame
providing a template for the configuration outputs, with the
following columns:
\itemize{
\item name
\item outputType
\item attribute
}

The only column of interest to the user is the \code{attribute}
column, this is the column that should be changed for
customization.

\code{avworkflow_configuration_update()} returns a list structure
describing the updated configuration.

\code{avworkflow_configuration_set()} returns an object
describing the updated configuration. The return value includes
invalid or unused elements of the \code{config} input. Invalid or
unused elements of \code{config} are also reported as a warning.

\code{avworkflow_configuration_template()} returns a list
providing a template for configuration lists, with the
following structure:
\itemize{
\item namespace character(1) configuration namespace.
\item name character(1) configuration name.
\item rootEntityType character(1) or missing. the name of the table
(from \code{avtables()}) containing the entitites referenced in
inputs, etc., by the keyword 'this.'
\item prerequisites named list (possibly empty) of prerequisites.
\item inputs named list (possibly empty) of inputs. Form of input
depends on method, and might include, e.g., a reference to a
field in a table referenced by \code{avtables()} or a character string
defining an input constant.
\item outputs named list (possibly empty) of outputs.
\item methodConfigVersion integer(1) identifier for the method
configuration.
\item methodRepoMethod named list describing the method, with
character(1) elements described in the return value for \code{avworkflows()}.
\itemize{
\item methodUri
\item sourceRepo
\item methodPath
\item methodVersion. The REST specification indicates that this has
type \code{integer}, but the documentation indicates either
\code{integer} or \code{string}.
}
\item deleted logical(1) of uncertain purpose.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\cr
Functions on this help page facilitate getting,
updating, and setting workflow configuration parameters. See
\code{?avworkflows} for additional relevant functionality.

\code{avworkflow_namespace()} and \code{avworkflow_name()} are
utility functions to record the workflow namespace and name
required when working with workflow
configurations. \code{avworkflow()} provides a convenient way to
provide workflow namespace and name in a single command,
\code{namespace/name}.

\code{avworkflow_configuration_get()} returns a list structure
describing an existing workflow configuration.

\code{avworkflow_configuration_inputs()} returns a
data.frame template for the inputs defined in a workflow
configuration.  This template can be used to provide custom
inputs for a configuration.

\code{avworkflow_configuration_outputs()} returns a
data.frame template for the outputs defined in a workflow
configuration.  This template can be used to provide custom
outputs for a configuration.

\code{avworkflow_configuration_update()} returns a list structure
describing a workflow configuration with updated inputs and / or outputs.

\code{avworkflow_configuration_set()} updates an existing
configuration in Terra / AnVIL, e.g., changing inputs to the
workflow.

\code{avworkflow_configuration_template()} returns a
template for defining workflow configurations. This template
can be used as a starting point for providing a custom
configuration.
}
\details{
The exact format of the configuration is important.

One common problem is that a scalar character vector \code{"bar"} is
interpretted as a json 'array' \verb{["bar"]} rather than a json string
\code{"bar"}. Enclose the string with \code{jsonlite::unbox("bar")} in the
configuration list if the length 1 character vector in R is to be
interpretted as a json string.

A second problem is that an unquoted unboxed character string
\code{unbox("foo")} is required by AnVIL to be quoted. This is reported
as a warning() about invalid inputs or outputs, and the solution is
to provide a quoted string \code{unbox('"foo"')}.
}
\seealso{
The help page \code{?avworkflows} for discovering, running,
stopping, and retrieving outputs from workflows.
}
