% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avworkflow.R
\name{avworkflows-defunct}
\alias{avworkflows-defunct}
\alias{avworkflows}
\alias{avworkflow_files}
\alias{avworkflow_localize}
\alias{avworkflow_run}
\alias{avworkflow_stop}
\alias{avworkflow_info}
\title{DEFUNCT - Workflow submissions and file outputs}
\usage{
avworkflows(namespace = avworkspace_namespace(), name = avworkspace_name())

avworkflow_files(
  submissionId = NULL,
  workflowId = NULL,
  bucket = avbucket(),
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)

avworkflow_localize(
  submissionId = NULL,
  workflowId = NULL,
  destination = NULL,
  type = c("control", "output", "all"),
  bucket = avbucket(),
  dry = TRUE
)

avworkflow_run(
  config,
  entityName,
  entityType = config$rootEntityType,
  deleteIntermediateOutputFiles = FALSE,
  useCallCache = TRUE,
  useReferenceDisks = FALSE,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  dry = TRUE
)

avworkflow_stop(
  submissionId = NULL,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  dry = TRUE
)

avworkflow_info(
  submissionId = NULL,
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)
}
\arguments{
\item{namespace}{character(1) AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{name}{character(1) AnVIL workspace name as returned by, eg.,
\code{avworkspace_name()}.}

\item{submissionId}{a character() of workflow submission ids, or a
tibble with column \code{submissionId}, or NULL / missing. See
'Details'.}

\item{workflowId}{a character(1) of internal identifier associated with one
workflow in the submission, or NULL / missing.}

\item{bucket}{character(1) DEPRECATED (ignored in the current
release) name of the google bucket in which the workflow
products are available, as \verb{gs://...}. Usually the bucket of
the active workspace, returned by \code{avbucket()}.}

\item{destination}{character(1) file path to the location where
files will be synchronized. For directories in the current
working directory, be sure to prepend with \code{"./"}. When \code{NULL},
the \code{submissionId} is used as the destination. \code{destination}
may also be a google bucket, in which case th workflow files
are synchronized from the workspace to a second bucket.}

\item{type}{character(1) copy \code{"control"} (default), \code{"output"}, or
\code{"all"} files produced by a workflow.}

\item{dry}{logical(1) when \code{TRUE} (default), report the
consequences but do not perform the action requested. When
\code{FALSE}, perform the action.}

\item{config}{a \code{avworkflow_configuration} object of the workflow
that will be run. Only \code{entityType} and method configuration
name and namespace are used from \code{config}; other configuration
values must be communicated to AnVIL using
\code{avworkflow_configuration_set()}.}

\item{entityName}{character(1) or NULL name of the set of samples
to be used when running the workflow. NULL indicates that no
sample set will be used.}

\item{entityType}{character(1) or NULL type of root entity used for
the workflow. NULL means that no root entity will be used.}

\item{deleteIntermediateOutputFiles}{logical(1) whether or not to delete
intermediate output files when the workflow completes.}

\item{useCallCache}{logical(1) whether or not to read from cache for this
submission.}

\item{useReferenceDisks}{logical(1) whether or not to use pre-built
disks for common genome references. Default: \code{FALSE}.}
}
\value{
\code{avworkflows()} returns a tibble. Each workflow is in a
'namespace' and has a 'name', as illustrated in the
example. Columns are
\itemize{
\item name: workflow name.
\item namespace: workflow namespace (often the same as the workspace namespace).
\item rootEntityType: name of the \code{avtable()} used to retrieve inputs.
\item methodRepoMethod.methodUri: source of the method, e.g., a dockstore URI.
\item methodRepoMethod.sourceRepo: source repository, e.g., dockstore.
\item methodRepoMethod.methodPath: path to method, e.g., a dockerstore
method might reference a github repository.
\item methodRepoMethod.methodVersion: the version of the method, e.g.,
'main' branch of a github repository.
}

\code{avworkflow_files()} returns a tibble with columns
\itemize{
\item file: character() 'base name' of the file in the bucket.
\item workflow: character() name of the workflow the file is associated
with.
\item task: character() name of the task in the workflow that generated
the file.
\item path: charcter() full path to the file in the google bucket.
\item submissionId: character() internal identifier associated with the
submission the files belong to.
\item workflowId: character() internal identifer associated with each
workflow (e.g., row of an avtable() used as input) in the
submission.
\item submissionRoot: character() path in the workspace bucket to the root
of files created by this submission.
\item namespace: character() AnVIL workspace namespace (billing account)
associated with the submissionId.
\item name: character(1) AnVIL workspace name associated with the
submissionId.
}

\code{avworkflow_localize()} prints a message indicating the
number of files that are (if \code{dry = FALSE}) or would be
localized. If no files require localization (i.e., local files
are not older than the bucket files), then no files are
localized. \code{avworkflow_localize()} returns a tibble of file
name and bucket path of files to be synchronized.

\code{avworkflow_run()} returns \code{config}, invisibly. Note that \code{config}
has an added \code{LastSubmissionId} value for the submission ID of the last
run workflow.

\code{avworkflow_stop()} returns (invisibly) \code{TRUE} on
successfully requesting that the workflow stop, \code{FALSE} if the
workflow is already aborting, aborted, or done.

\code{avworkflow_info()} returns a tibble with columns:
submissionId, workflowId, workflowName,status, start, end,
inputs and outputs.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\cr
\code{avworkflows()} returns a tibble summarizing available
workflows.

\code{avworkflow_files()} returns a tibble containing
information and file paths to workflow outputs.

\code{avworkflow_localize()} creates or synchronizes a
local copy of files with files stored in the workspace bucket
and produced by the workflow.

\code{avworkflow_run()} submits and runs the workflow of the
configuration.

\code{avworkflow_stop()} stops the most recently submitted workflow
jub from running.

\code{avworkflow_info()} returns a tibble containing workflow
information, including workflowName, status, start and end time,
inputs and outputs.
}
\details{
For \code{avworkflow_files()}, the \code{submissionId} is the
identifier associated with the submission of one (or more)
workflows, and is present in the return value of
\code{avworkflow_jobs()}; the example illustrates how the first row
of \code{avworkflow_jobs()} (i.e., the most recently completed
workflow) can be used as input to \code{avworkflow_files()}. When
\code{submissionId} is not provided, the return value is for the
most recently submitted workflow of the namespace and name of
\code{avworkspace()}.

\code{avworkflow_localize()}. \code{type = "control"} files
summarize workflow progress; they can be numerous but are
frequently small and quickly syncronized. \code{type = "output"}
files are the output products of the workflow stored in the
workspace bucket. Depending on the workflow, outputs may be
large, e.g., aligned reads in bam files. See \code{gsutil_cp()} to
copy individual files from the bucket to the local drive.

\code{avworkflow_localize()} treats \verb{submissionId=} in the same way as
\code{avworkflow_files()}: when missing, files from the most recent
workflow job are candidates for localization.

\code{avworkflow_run()} invisibly returns a slightly modified \code{config}
object. The new \code{config} object has an added \code{LastSubmissionId} value that
identifies the submitted job.
}
