% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{DE_analyze}
\alias{DE_analyze}
\title{Differential Expression Analysis}
\usage{
DE_analyze(se, method, batch, conditions, assay_to_analyze)
}
\arguments{
\item{se}{SummarizedExperiment object}

\item{method}{DE analysis method option (either 'DESeq2' or 'limma')}

\item{batch}{metadata column in the se object representing batch}

\item{conditions}{metadata columns in the se object representing additional
analysis covariates}

\item{assay_to_analyze}{Assay in the se object (either counts for DESeq2 or
normalized data for limma) for DE analysis}
}
\value{
A named list containing the log2FoldChange, pvalue and adjusted
pvalue (padj) for each analysis returned by DESeq2 or limma
}
\description{
This function runs DE analysis on a count matrix (DESeq) or a normalized log
or log-CPM matrix (limma) contained in the se object
}
\examples{
library(scran)
se <- mockSCE()
differential_expression <- BatchQC::DE_analyze(se = se,
                                                method = "DESeq2",
                                                batch = "Treatment",
                                                conditions = c(
                                                "Mutation_Status"),
                                                assay_to_analyze = "counts")
pval_summary(differential_expression)
pval_plotter(differential_expression)

}
